package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTrayInfo;

/**
 * 托盘信息Mapper接口
 * 
 * @author zehong
 * @date 2025-06-06
 */
public interface TTrayInfoMapper 
{
    /**
     * 查询托盘信息
     * 
     * @param fTrayId 托盘信息ID
     * @return 托盘信息
     */
    public TTrayInfo selectTTrayInfoById(Long fTrayId);

    public TTrayInfo selectTTrayInfoByCode(String code);

    /**
     * 查询托盘信息列表
     * 
     * @param tTrayInfo 托盘信息
     * @return 托盘信息集合
     */
    public List<TTrayInfo> selectTTrayInfoList(TTrayInfo tTrayInfo);

    /**
     * 新增托盘信息
     * 
     * @param tTrayInfo 托盘信息
     * @return 结果
     */
    public int insertTTrayInfo(TTrayInfo tTrayInfo);

    public int batchInsertTTrayInfo(List<TTrayInfo> tTrayInfoList);

    /**
     * 修改托盘信息
     * 
     * @param tTrayInfo 托盘信息
     * @return 结果
     */
    public int updateTTrayInfo(TTrayInfo tTrayInfo);

    public int unbindByCode(TTrayInfo tTrayInfo);
    /**
     * 删除托盘信息
     * 
     * @param fTrayId 托盘信息ID
     * @return 结果
     */
    public int deleteTTrayInfoById(Long fTrayId);

    /**
     * 批量删除托盘信息
     * 
     * @param fTrayIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTrayInfoByIds(Long[] fTrayIds);
}
