package com.zehong.web.controller.equipment;

import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.ProductStandardInspection;
import com.zehong.system.service.IProductStandardInspectionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 产品主体标检单Controller
 *
 * @author zehong
 * @date 2026-01-17
 */
@RestController
@RequestMapping("/system/inspection")
public class ProductStandardInspectionController extends BaseController
{
    @Autowired
    private IProductStandardInspectionService productStandardInspectionService;

    /**
     * 查询产品主体标检单列表
     */
    @GetMapping("/list")
    public TableDataInfo list(ProductStandardInspection productStandardInspection)
    {
        startPage();
        List<ProductStandardInspection> list = productStandardInspectionService.selectProductStandardInspectionList(productStandardInspection);
        return getDataTable(list);
    }

    /**
     * 查询
     */
    @GetMapping("/listDuringStandardInspection")
    public AjaxResult listDuringStandardInspection() {
        List<ProductStandardInspection> list = productStandardInspectionService.selectDuringStandardInspection();
        return AjaxResult.success(list);
    }

    /**
     * 导出产品主体标检单列表
     */
    @GetMapping("/export")
    public AjaxResult export(ProductStandardInspection productStandardInspection)
    {
        List<ProductStandardInspection> list = productStandardInspectionService.selectProductStandardInspectionList(productStandardInspection);
        ExcelUtil<ProductStandardInspection> util = new ExcelUtil<ProductStandardInspection>(ProductStandardInspection.class);
        return util.exportExcel(list, "产品主体标检单数据");
    }

    /**
     * 同步MES数据
     */
    @GetMapping("/syncMESData")
    public void syncMESData() {
        productStandardInspectionService.syncMESData();
    }


    /**
     * 获取产品主体标检单详细信息
     */
    @GetMapping(value = "/{productStandardInspectionId}")
    public AjaxResult getInfo(@PathVariable("productStandardInspectionId") Long productStandardInspectionId)
    {
        return AjaxResult.success(productStandardInspectionService.selectProductStandardInspectionById(productStandardInspectionId));
    }

    /**
     * 新增产品主体标检单
     */
    @PostMapping
    public AjaxResult add(@RequestBody ProductStandardInspection productStandardInspection)
    {
        return toAjax(productStandardInspectionService.insertProductStandardInspection(productStandardInspection));
    }

    /**
     * 修改产品主体标检单
     */
    @PutMapping
    public AjaxResult edit(@RequestBody ProductStandardInspection productStandardInspection)
    {
        return toAjax(productStandardInspectionService.updateProductStandardInspection(productStandardInspection));
    }

    /**
     * 删除产品主体标检单
     */
	@DeleteMapping("/{productStandardInspectionIds}")
    public AjaxResult remove(@PathVariable Long[] productStandardInspectionIds)
    {
        return toAjax(productStandardInspectionService.deleteProductStandardInspectionByIds(productStandardInspectionIds));
    }
}
