package com.zehong.system.service.impl;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.SysRealTimeAdRange;
import com.zehong.system.mapper.SysRealTimeAdRangeMapper;
import com.zehong.system.service.ISysRealTimeAdRangeService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 实时AD范围维护Service业务层处理
 * 
 * @author zehong
 * @date 2025-11-22
 */
@Service
public class SysRealTimeAdRangeServiceImpl implements ISysRealTimeAdRangeService 
{
    @Resource
    private SysRealTimeAdRangeMapper sysRealTimeAdRangeMapper;

    /**
     * 查询实时AD范围维护
     * 
     * @param id 实时AD范围维护ID
     * @return 实时AD范围维护
     */
    @Override
    public SysRealTimeAdRange selectSysRealTimeAdRangeById(Long id)
    {
        return sysRealTimeAdRangeMapper.selectSysRealTimeAdRangeById(id);
    }

    /**
     * 查询实时AD范围维护列表
     * 
     * @param sysRealTimeAdRange 实时AD范围维护
     * @return 实时AD范围维护
     */
    @Override
    public List<SysRealTimeAdRange> selectSysRealTimeAdRangeList(SysRealTimeAdRange sysRealTimeAdRange)
    {
        return sysRealTimeAdRangeMapper.selectSysRealTimeAdRangeList(sysRealTimeAdRange);
    }

    @Override
    public AjaxResult getTopOne() {
        return AjaxResult.success(sysRealTimeAdRangeMapper.getTopOne());
    }

    /**
     * 新增实时AD范围维护
     * 
     * @param sysRealTimeAdRange 实时AD范围维护
     * @return 结果
     */
    @Override
    public Long insertSysRealTimeAdRange(SysRealTimeAdRange sysRealTimeAdRange)
    {
        sysRealTimeAdRangeMapper.insertSysRealTimeAdRange(sysRealTimeAdRange);
        return sysRealTimeAdRange.getId();
    }

    /**
     * 修改实时AD范围维护
     * 
     * @param sysRealTimeAdRange 实时AD范围维护
     * @return 结果
     */
    @Override
    public int updateSysRealTimeAdRange(SysRealTimeAdRange sysRealTimeAdRange)
    {
        return sysRealTimeAdRangeMapper.updateSysRealTimeAdRange(sysRealTimeAdRange);
    }

    /**
     * 批量删除实时AD范围维护
     * 
     * @param ids 需要删除的实时AD范围维护ID
     * @return 结果
     */
    @Override
    public int deleteSysRealTimeAdRangeByIds(Long[] ids)
    {
        return sysRealTimeAdRangeMapper.deleteSysRealTimeAdRangeByIds(ids);
    }

    /**
     * 删除实时AD范围维护信息
     * 
     * @param id 实时AD范围维护ID
     * @return 结果
     */
    @Override
    public int deleteSysRealTimeAdRangeById(Long id)
    {
        return sysRealTimeAdRangeMapper.deleteSysRealTimeAdRangeById(id);
    }
}
