package com.zehong.web.controller.equipment;

import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.PalletDeviceUploadHistory;
import com.zehong.system.service.IPalletDeviceUploadHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 未上传成功的历史数据列Controller
 * 
 * @author zehong
 * @date 2025-11-24
 */
@RestController
@RequestMapping("/palletDevice/binding/history")
public class PalletDeviceUploadHistoryController extends BaseController
{
    @Autowired
    private IPalletDeviceUploadHistoryService palletDeviceUploadHistoryService;

    /**
     * 查询未上传成功的历史数据列列表
     */
    @GetMapping("/list")
    public TableDataInfo list(PalletDeviceUploadHistory palletDeviceUploadHistory)
    {
        startPage();
        List<PalletDeviceUploadHistory> list = palletDeviceUploadHistoryService.selectPalletDeviceUploadHistoryList(palletDeviceUploadHistory);
        return getDataTable(list);
    }

    /**
     * 导出未上传成功的历史数据列列表
     */
    @GetMapping("/export")
    public AjaxResult export(PalletDeviceUploadHistory palletDeviceUploadHistory)
    {
        List<PalletDeviceUploadHistory> list = palletDeviceUploadHistoryService.selectPalletDeviceUploadHistoryList(palletDeviceUploadHistory);
        ExcelUtil<PalletDeviceUploadHistory> util = new ExcelUtil<PalletDeviceUploadHistory>(PalletDeviceUploadHistory.class);
        return util.exportExcel(list, "未上传成功的历史数据列数据");
    }

    /**
     * 获取未上传成功的历史数据列详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(palletDeviceUploadHistoryService.selectPalletDeviceUploadHistoryById(id));
    }

    /**
     * 新增未上传成功的历史数据列
     */
    @PostMapping
    public AjaxResult add(@RequestBody PalletDeviceUploadHistory palletDeviceUploadHistory)
    {
        return toAjax(palletDeviceUploadHistoryService.insertPalletDeviceUploadHistory(palletDeviceUploadHistory));
    }

    /**
     * 重新上传
     */
    @GetMapping("/handleReUpload")
    public AjaxResult handleReUpload(){
        return palletDeviceUploadHistoryService.handleReUpload();
    }

    /**
     * 修改未上传成功的历史数据列
     */
    @PutMapping
    public AjaxResult edit(@RequestBody PalletDeviceUploadHistory palletDeviceUploadHistory)
    {
        return toAjax(palletDeviceUploadHistoryService.updatePalletDeviceUploadHistory(palletDeviceUploadHistory));
    }

    /**
     * 删除未上传成功的历史数据列
     */
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(palletDeviceUploadHistoryService.deletePalletDeviceUploadHistoryByIds(ids));
    }
}
