package com.zehong.system.domain;

import com.zehong.common.core.domain.BaseEntity;

import java.math.BigDecimal;

/**
 * @author lenovo
 * @date 2025/11/22
 * @description MES设备对象
 */
public class MesDeviceDomain extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 主板码 */
    private String motherboardCode;

    /**
     * 零点AD值
     */
    private String zeroAdValue;

    /**
     *零点状态 0-未校准 1-已校准
     */
    private String zeroStatus;

    /**
     * 校准AD值
     */
    private String calibratedAdValue;
    /**
     * 校准状态
     */
    private String calibrationStatus;

    /**
     * 浓度
     */
    private String concentration;

    /**
     * 实时AD
     */
    private Integer realTimeAd;

    /**
     * 实时状态 0-异常;1-正常
     */
    private String realTimeStatus;
    /**
     * 标定浓度值
     */
    private BigDecimal calibrationConcentration;

    /**
     * 标定状态 4-正常，其他都是异常
     * 0-预热；1-正常；3-传感器故障；4-报警；5-通讯故障； 只有是4的时候显示正常，其他的都是异常
     */
    private String calibrationConcentrationStatus;

    public String getMotherboardCode() {
        return motherboardCode;
    }

    public void setMotherboardCode(String motherboardCode) {
        this.motherboardCode = motherboardCode;
    }

    public String getZeroAdValue() {
        return zeroAdValue;
    }

    public void setZeroAdValue(String zeroAdValue) {
        this.zeroAdValue = zeroAdValue;
    }

    public String getZeroStatus() {
        return zeroStatus;
    }

    public void setZeroStatus(String zeroStatus) {
        this.zeroStatus = zeroStatus;
    }

    public String getCalibratedAdValue() {
        return calibratedAdValue;
    }

    public void setCalibratedAdValue(String calibratedAdValue) {
        this.calibratedAdValue = calibratedAdValue;
    }

    public String getCalibrationStatus() {
        return calibrationStatus;
    }

    public void setCalibrationStatus(String calibrationStatus) {
        this.calibrationStatus = calibrationStatus;
    }

    public String getConcentration() {
        return concentration;
    }

    public void setConcentration(String concentration) {
        this.concentration = concentration;
    }

    public Integer getRealTimeAd() {
        return realTimeAd;
    }

    public void setRealTimeAd(Integer realTimeAd) {
        this.realTimeAd = realTimeAd;
    }

    public String getRealTimeStatus() {
        return realTimeStatus;
    }

    public void setRealTimeStatus(String realTimeStatus) {
        this.realTimeStatus = realTimeStatus;
    }

    public BigDecimal getCalibrationConcentration() {
        return calibrationConcentration;
    }

    public void setCalibrationConcentration(BigDecimal calibrationConcentration) {
        this.calibrationConcentration = calibrationConcentration;
    }

    public String getCalibrationConcentrationStatus() {
        return calibrationConcentrationStatus;
    }

    public void setCalibrationConcentrationStatus(String calibrationConcentrationStatus) {
        this.calibrationConcentrationStatus = calibrationConcentrationStatus;
    }
}
