package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 机械臂指令对象 t_robot_arm_command
 * 
 * @author zehong
 * @date 2025-08-04
 */
public class RobotArmCommand extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long robotArmCommandId;

    /** 托盘编号 */
    @Excel(name = "托盘编号")
    private String trayCode;

    /** 绑定层编号 */
    @Excel(name = "绑定层编号")
    private String storeyCode;

    /** 类型：0-待上料；1-待下料 */
    @Excel(name = "类型：0-待上料；1-待下料")
    private String type;

    /** 状态：0-待执行；1-执行中；2-执行结束(上料就是绑定托盘，下料就是解绑托盘) */
    @Excel(name = "状态：0-待分配位置，1-待执行；2-执行中；3-未上电；4-执行结束(上料就是绑定托盘，下料就是解绑托盘)")
    private String status;

    /** 指令开始执行时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "指令开始执行时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startExecutionTime;

    /** 指令结束执行时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "指令结束执行时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endExecutionTime;

    /** 指令 */
    private String command;


    public void setRobotArmCommandId(Long robotArmCommandId) 
    {
        this.robotArmCommandId = robotArmCommandId;
    }

    public Long getRobotArmCommandId() 
    {
        return robotArmCommandId;
    }
    public void setTrayCode(String trayCode) 
    {
        this.trayCode = trayCode;
    }

    public String getTrayCode() 
    {
        return trayCode;
    }
    public void setStoreyCode(String storeyCode) 
    {
        this.storeyCode = storeyCode;
    }

    public String getStoreyCode() 
    {
        return storeyCode;
    }
    public void setType(String type) 
    {
        this.type = type;
    }

    public String getType() 
    {
        return type;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setStartExecutionTime(Date startExecutionTime) 
    {
        this.startExecutionTime = startExecutionTime;
    }

    public Date getStartExecutionTime() 
    {
        return startExecutionTime;
    }
    public void setEndExecutionTime(Date endExecutionTime) 
    {
        this.endExecutionTime = endExecutionTime;
    }

    public Date getEndExecutionTime() 
    {
        return endExecutionTime;
    }

    public String getCommand() {
        return command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("robotArmCommandId", getRobotArmCommandId())
            .append("trayCode", getTrayCode())
            .append("storeyCode", getStoreyCode())
            .append("type", getType())
            .append("status", getStatus())
            .append("startExecutionTime", getStartExecutionTime())
            .append("endExecutionTime", getEndExecutionTime())
            .append("createTime", getCreateTime())
            .append("command", getCommand())
            .toString();
    }
}
