package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.SysRealTimeAdRange;

/**
 * 实时AD范围维护Mapper接口
 * 
 * @author zehong
 * @date 2025-11-22
 */
public interface SysRealTimeAdRangeMapper 
{
    /**
     * 查询实时AD范围维护
     * 
     * @param id 实时AD范围维护ID
     * @return 实时AD范围维护
     */
    public SysRealTimeAdRange selectSysRealTimeAdRangeById(Long id);

    /**
     * 查询实时AD范围维护列表
     * 
     * @param sysRealTimeAdRange 实时AD范围维护
     * @return 实时AD范围维护集合
     */
    public List<SysRealTimeAdRange> selectSysRealTimeAdRangeList(SysRealTimeAdRange sysRealTimeAdRange);

    public SysRealTimeAdRange getTopOne();

    /**
     * 新增实时AD范围维护
     * 
     * @param sysRealTimeAdRange 实时AD范围维护
     * @return 结果
     */
    public int insertSysRealTimeAdRange(SysRealTimeAdRange sysRealTimeAdRange);

    /**
     * 修改实时AD范围维护
     * 
     * @param sysRealTimeAdRange 实时AD范围维护
     * @return 结果
     */
    public int updateSysRealTimeAdRange(SysRealTimeAdRange sysRealTimeAdRange);

    /**
     * 删除实时AD范围维护
     * 
     * @param id 实时AD范围维护ID
     * @return 结果
     */
    public int deleteSysRealTimeAdRangeById(Long id);

    /**
     * 批量删除实时AD范围维护
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteSysRealTimeAdRangeByIds(Long[] ids);
}
