package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.UploadMesResultHistory;

/**
 * 上传MES返回结果历史记录Mapper接口
 * 
 * @author zehong
 * @date 2025-12-03
 */
public interface UploadMesResultHistoryMapper 
{
    /**
     * 查询上传MES返回结果历史记录
     * 
     * @param id 上传MES返回结果历史记录ID
     * @return 上传MES返回结果历史记录
     */
    public UploadMesResultHistory selectUploadMesResultHistoryById(Long id);

    /**
     * 查询上传MES返回结果历史记录列表
     * 
     * @param uploadMesResultHistory 上传MES返回结果历史记录
     * @return 上传MES返回结果历史记录集合
     */
    public List<UploadMesResultHistory> selectUploadMesResultHistoryList(UploadMesResultHistory uploadMesResultHistory);

    /**
     * 新增上传MES返回结果历史记录
     * 
     * @param uploadMesResultHistory 上传MES返回结果历史记录
     * @return 结果
     */
    public int insertUploadMesResultHistory(UploadMesResultHistory uploadMesResultHistory);

    /**
     * 修改上传MES返回结果历史记录
     * 
     * @param uploadMesResultHistory 上传MES返回结果历史记录
     * @return 结果
     */
    public int updateUploadMesResultHistory(UploadMesResultHistory uploadMesResultHistory);

    /**
     * 删除上传MES返回结果历史记录
     * 
     * @param id 上传MES返回结果历史记录ID
     * @return 结果
     */
    public int deleteUploadMesResultHistoryById(Long id);

    /**
     * 批量删除上传MES返回结果历史记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteUploadMesResultHistoryByIds(Long[] ids);
}
