import request from '@/utils/request'

// 查询老化层信息列表
export function listStorey(query) {
  return request({
    url: '/storey/list',
    method: 'get',
    params: query
  })
}

// 根据设备id查询老化层信息列表
export function queryByDepartmentId(fDepartmentId) {
  return request({
    url: '/storey/queryByDepartmentId/' +fDepartmentId,
    method: 'get'
  })
}

// 查询老化层信息详细
export function getStorey(fStoreyId) {
  return request({
    url: '/storey/' + fStoreyId,
    method: 'get'
  })
}

// 新增老化层信息
export function addStorey(data) {
  return request({
    url: '/storey',
    method: 'post',
    data: data
  })
}

// 修改老化层信息
export function updateStorey(data) {
  return request({
    url: '/storey',
    method: 'put',
    data: data
  })
}

// 删除老化层信息
export function delStorey(fStoreyId) {
  return request({
    url: '/storey/' + fStoreyId,
    method: 'delete'
  })
}

// 导出老化层信息
export function exportStorey(query) {
  return request({
    url: '/storey/export',
    method: 'get',
    params: query
  })
}


export function  PowerOn(query) {
  return request({
    url: '/storey/powerOn',
    method: 'get',
    params: query
  })
}

export function PowerOutage(query) {
  return request({
    url: '/storey/powerOutage',
    method: 'get',
    params: query
  })
}

export  function feeding(command) {
  return request({
    url: '/storey/handleFeeding/' + command,
    method: 'get'
  })
}
export function blanking(command) {
  return request({
    url: '/storey/handleBlanking/' + command,
    method: 'get'
  })
}

export function reAgine(query) {
  return request({
    url: '/storey/handleReAgine/',
    method: 'get',
    params: query
  })
}

export function clearTasks(query) {
  return request({
    url: '/storey/handleClearTasks/',
    method: 'get',
    params: query
  })
}
export function directBlanking(command) {
  return request({
    url: '/storey/handleDirectBlanking/' + command,
    method: 'get'
  })
}

export function readAgingData(fEquipmentCode) {
  return request({
    url: '/storey/readAgingData/' + fEquipmentCode,
    method: 'get'
  })
}

export function batchReadingCabinetStatus(fEquipmentCode) {
  return request({
    url: '/storey/batchReadingCabinetStatus/' + fEquipmentCode,
    method: 'get'
  })
}

export function readingHoldingRegister(storeyCode) {
  return request({
    url: '/storey/handleReadingHoldingRegister/' + storeyCode,
    method: 'get'
  })
}
export function powerOnAllStore() {
  return request({
    url: '/storey/powerOnAllStore',
    method: 'get'
  })
}
export function designatedDevicePowerOn(equipmentCode) {
  return request({
    url: '/storey/designatedDevicePowerOn/' + equipmentCode,
    method: 'get'
  })
}
export function designatedDevicePowerOff(equipmentCode) {
  return request({
    url: '/storey/designatedDevicePowerOff/' + equipmentCode,
    method: 'get'
  })
}

export function powerOffAllStore() {
  return request({
    url: '/storey/powerOffAllStore',
    method: 'get'
  })
}

export function scanAndStartAgingAllCabinetLayers() {
  return request({
    url: '/storey/scanAndStartAgingAllCabinetLayers',
    method: 'get'
  })
}
