CREATE TABLE `t_process_calibration_result_history` (
    `f_id` BIGINT ( 20 ) NOT NULL AUTO_INCREMENT COMMENT 'id',
    `f_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `f_message` LONGTEXT DEFAULT NULL COMMENT '内容',
    PRIMARY KEY ( `f_id` ) USING BTREE
) ENGINE = INNODB DEFAULT CHARSET = utf8mb4 ROW_FORMAT = DYNAMIC COMMENT = '标定结果数据接收历史记录';
http://36.138.180.82:8087/mes/pcba/devices/acceptAgingCalibrationResults
[
    {
        "motherboardCode":"PCBA2512010866",
        "concentration":"0.23",
        "deviceStatus":"1",
        "realTimeAd":0.13,
        "realTimeStatus":"1",
        "calibrationConcentration":10,
        "calibrationConcentrationStatus":"3",
        "writeTimeStatus":"1",
        "runTimeStatus":"0",
        "recordYear":"2025",
        "recordMonth":"11",
        "recordDate":"12",
        "recordHour":"13",
        "recordMinute":"14"
    }
]
ALTER TABLE `t_pallet_device_binding`
    ADD COLUMN `f_write_self_check_status` INT(16) DEFAULT NULL COMMENT '写入自检状态(可以是空，0-失败，1-成功)',
ADD COLUMN `f_relay_status` INT(16) DEFAULT NULL COMMENT '继电器状态(0-初始，1-动作)',
ADD COLUMN `f_pulse_status` INT(16) DEFAULT NULL COMMENT '脉冲状态(0-初始，1-动作)',
ADD COLUMN `f_module_status` INT(16) DEFAULT NULL COMMENT '模组状态(0-异常，1-正常)',
ADD COLUMN `f_sim_card_status` INT(16) DEFAULT NULL COMMENT 'SIM卡状态(0-异常，1-正常)',
ADD COLUMN `f_network_status` INT(16) DEFAULT NULL COMMENT '网络状态(0-异常，1-正常)';



ALTER TABLE `t_pallet_device_upload_history`
    ADD COLUMN `f_write_self_check_status` INT(16) DEFAULT NULL COMMENT '写入自检状态(可以是空，0-失败，1-成功)',
ADD COLUMN `f_relay_status` INT(16) DEFAULT NULL COMMENT '继电器状态(0-初始，1-动作)',
ADD COLUMN `f_pulse_status` INT(16) DEFAULT NULL COMMENT '脉冲状态(0-初始，1-动作)',
ADD COLUMN `f_module_status` INT(16) DEFAULT NULL COMMENT '模组状态(0-异常，1-正常)',
ADD COLUMN `f_sim_card_status` INT(16) DEFAULT NULL COMMENT 'SIM卡状态(0-异常，1-正常)',
ADD COLUMN `f_network_status` INT(16) DEFAULT NULL COMMENT '网络状态(0-异常，1-正常)';



-- 1. 删除 ERROR 触发器的“触发历史”（qrtz_fired_triggers）
DELETE FROM qrtz_fired_triggers
WHERE
        TRIGGER_NAME IN (SELECT TRIGGER_NAME FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR')
  AND TRIGGER_GROUP IN (SELECT TRIGGER_GROUP FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR');

-- 2. 删除 ERROR 触发器的“Cron配置”（若为Cron触发器，对应你的COMM_*任务）
DELETE FROM qrtz_cron_triggers
WHERE
        TRIGGER_NAME IN (SELECT TRIGGER_NAME FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR')
  AND TRIGGER_GROUP IN (SELECT TRIGGER_GROUP FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR');

-- 3. 删除 ERROR 触发器的“Simple配置”（若为Simple触发器，对应你的FINAL_*任务）
DELETE FROM qrtz_simple_triggers
WHERE
        TRIGGER_NAME IN (SELECT TRIGGER_NAME FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR')
  AND TRIGGER_GROUP IN (SELECT TRIGGER_GROUP FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR');

-- 4. 删除 ERROR 状态的触发器本身（qrtz_triggers）
DELETE FROM qrtz_triggers
WHERE
        TRIGGER_STATE = 'ERROR';

-- 5. 删除关联的无效 Job（若这些 Job 不再使用，对应你的COMM_*和FINAL_*任务）
DELETE FROM qrtz_job_details
WHERE
        JOB_NAME IN (
        SELECT JOB_NAME FROM qrtz_triggers WHERE TRIGGER_STATE = 'ERROR'
    ) OR
        JOB_NAME LIKE 'COMM_%' OR  -- 确保清理所有旧的通信任务
        JOB_NAME LIKE 'FINAL_%';   -- 确保清理所有旧的最终任务
