package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 未上传成功的历史数据列对象 t_pallet_device_upload_history
 * 
 * @author zehong
 * @date 2025-11-24
 */
public class PalletDeviceUploadHistory extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 托盘id */
    private Long id;

    /** 托盘id */
    @Excel(name = "托盘id")
    private Long trayId;

    /** 托盘编号 */
    private String trayCode;

    /** 绑定的设备编号 */
    @Excel(name = "绑定的设备编号")
    private String deviceCode;

    /** 行 */
    @Excel(name = "行")
    private Integer row;

    /** 列 */
    @Excel(name = "列")
    private Integer col;

    /** 第几个 */
    @Excel(name = "第几个")
    private Integer index;

    /** 编号 */
    @Excel(name = "编号")
    private Integer number;

    /** 绑定时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "绑定时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date bindingTime;

    /** 解绑时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "解绑时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date unbindingTime;

    /** 0-预热；1-正常;3-传感器故障;4-报警；5-通讯故障 */
    @Excel(name = "0-预热；1-正常;3-传感器故障;4-报警；5-通讯故障")
    private String status;

    /** 设置-年 */
    @Excel(name = "设置-年")
    private String recordYear;

    /** 设置-月 */
    @Excel(name = "设置-月")
    private String recordMonth;

    /** 设置-日 */
    @Excel(name = "设置-日")
    private String recordDate;

    /** 设置-时 */
    @Excel(name = "设置-时")
    private String recordHour;

    /** 设置-分 */
    @Excel(name = "设置-分")
    private String recordMinute;

    /** 写入时间状态;0-失败;1-成功 */
    @Excel(name = "写入时间状态;0-失败;1-成功")
    private String writeTimeStatus;

    /** 调零AD */
    @Excel(name = "调零AD")
    private String adjustmentZeroAd;

    /** 合格；不合格 */
    @Excel(name = "合格；不合格")
    private String zeroStatus;

    /** 标定AD */
    @Excel(name = "标定AD")
    private String calibrationAd;

    /** 合格；不合格 */
    @Excel(name = "合格；不合格")
    private String calibrationStatus;

    /** 浓度值 */
    @Excel(name = "浓度值")
    private String concentration;

    /** 写入时间状态;0-失败;1-成功 */
    @Excel(name = "写入时间状态;0-失败;1-成功")
    private String runTimeStatus;

    /** 实时AD值 */
    @Excel(name = "实时AD值")
    private Integer realTimeAd;

    /** 实时AD状态;0-异常;1-正常 */
    @Excel(name = "实时AD状态;0-异常;1-正常")
    private String realTimeAdStatus;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTrayId(Long trayId) 
    {
        this.trayId = trayId;
    }

    public Long getTrayId() 
    {
        return trayId;
    }
    public void setDeviceCode(String deviceCode) 
    {
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode() 
    {
        return deviceCode;
    }
    public void setRow(Integer row) 
    {
        this.row = row;
    }

    public Integer getRow() 
    {
        return row;
    }
    public void setCol(Integer col) 
    {
        this.col = col;
    }

    public Integer getCol() 
    {
        return col;
    }
    public void setIndex(Integer index) 
    {
        this.index = index;
    }

    public Integer getIndex() 
    {
        return index;
    }
    public void setNumber(Integer number) 
    {
        this.number = number;
    }

    public Integer getNumber() 
    {
        return number;
    }
    public void setBindingTime(Date bindingTime) 
    {
        this.bindingTime = bindingTime;
    }

    public Date getBindingTime() 
    {
        return bindingTime;
    }
    public void setUnbindingTime(Date unbindingTime) 
    {
        this.unbindingTime = unbindingTime;
    }

    public Date getUnbindingTime() 
    {
        return unbindingTime;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setRecordYear(String recordYear) 
    {
        this.recordYear = recordYear;
    }

    public String getRecordYear() 
    {
        return recordYear;
    }
    public void setRecordMonth(String recordMonth) 
    {
        this.recordMonth = recordMonth;
    }

    public String getRecordMonth() 
    {
        return recordMonth;
    }
    public void setRecordDate(String recordDate) 
    {
        this.recordDate = recordDate;
    }

    public String getRecordDate() 
    {
        return recordDate;
    }
    public void setRecordHour(String recordHour) 
    {
        this.recordHour = recordHour;
    }

    public String getRecordHour() 
    {
        return recordHour;
    }
    public void setRecordMinute(String recordMinute) 
    {
        this.recordMinute = recordMinute;
    }

    public String getRecordMinute() 
    {
        return recordMinute;
    }
    public void setWriteTimeStatus(String writeTimeStatus) 
    {
        this.writeTimeStatus = writeTimeStatus;
    }

    public String getWriteTimeStatus() 
    {
        return writeTimeStatus;
    }
    public void setAdjustmentZeroAd(String adjustmentZeroAd) 
    {
        this.adjustmentZeroAd = adjustmentZeroAd;
    }

    public String getAdjustmentZeroAd() 
    {
        return adjustmentZeroAd;
    }
    public void setZeroStatus(String zeroStatus) 
    {
        this.zeroStatus = zeroStatus;
    }

    public String getZeroStatus() 
    {
        return zeroStatus;
    }
    public void setCalibrationAd(String calibrationAd) 
    {
        this.calibrationAd = calibrationAd;
    }

    public String getCalibrationAd() 
    {
        return calibrationAd;
    }
    public void setCalibrationStatus(String calibrationStatus) 
    {
        this.calibrationStatus = calibrationStatus;
    }

    public String getCalibrationStatus() 
    {
        return calibrationStatus;
    }
    public void setConcentration(String concentration) 
    {
        this.concentration = concentration;
    }

    public String getConcentration() 
    {
        return concentration;
    }
    public void setRunTimeStatus(String runTimeStatus) 
    {
        this.runTimeStatus = runTimeStatus;
    }

    public String getRunTimeStatus() 
    {
        return runTimeStatus;
    }
    public void setRealTimeAd(Integer realTimeAd)
    {
        this.realTimeAd = realTimeAd;
    }

    public Integer getRealTimeAd()
    {
        return realTimeAd;
    }
    public void setRealTimeAdStatus(String realTimeAdStatus) 
    {
        this.realTimeAdStatus = realTimeAdStatus;
    }

    public String getRealTimeAdStatus() 
    {
        return realTimeAdStatus;
    }

    public String getTrayCode() {
        return trayCode;
    }

    public void setTrayCode(String trayCode) {
        this.trayCode = trayCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("trayId", getTrayId())
            .append("deviceCode", getDeviceCode())
            .append("row", getRow())
            .append("col", getCol())
            .append("index", getIndex())
            .append("number", getNumber())
            .append("bindingTime", getBindingTime())
            .append("unbindingTime", getUnbindingTime())
            .append("createTime", getCreateTime())
            .append("status", getStatus())
            .append("recordYear", getRecordYear())
            .append("recordMonth", getRecordMonth())
            .append("recordDate", getRecordDate())
            .append("recordHour", getRecordHour())
            .append("recordMinute", getRecordMinute())
            .append("writeTimeStatus", getWriteTimeStatus())
            .append("adjustmentZeroAd", getAdjustmentZeroAd())
            .append("zeroStatus", getZeroStatus())
            .append("calibrationAd", getCalibrationAd())
            .append("calibrationStatus", getCalibrationStatus())
            .append("concentration", getConcentration())
            .append("runTimeStatus", getRunTimeStatus())
            .append("realTimeAd", getRealTimeAd())
            .append("realTimeAdStatus", getRealTimeAdStatus())
            .toString();
    }
}
