package com.zehong.system.domain;

import com.zehong.common.core.domain.BaseEntity;

/**
 * @author lenovo
 * @date 2025/11/22
 * @description MES设备对象
 */
public class MesDeviceDomain extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 主板码 */
    private String motherboardCode;

    /**
     * 零点AD值
     */
    private String zeroAdValue;

    /**
     *零点状态 0-未校准 1-已校准
     */
    private String zeroStatus;

    /**
     * 校准AD值
     */
    private String calibratedAdValue;
    /**
     * 校准状态
     */
    private String calibrationStatus;

    /**
     * 浓度
     */
    private String concentration;

    /**
     * 实时AD
     */
    private Integer realTimeAd;

    /**
     * 实时状态 0-异常;1-正常
     */
    private String realTimeStatus;

    public String getMotherboardCode() {
        return motherboardCode;
    }

    public void setMotherboardCode(String motherboardCode) {
        this.motherboardCode = motherboardCode;
    }

    public String getZeroAdValue() {
        return zeroAdValue;
    }

    public void setZeroAdValue(String zeroAdValue) {
        this.zeroAdValue = zeroAdValue;
    }

    public String getZeroStatus() {
        return zeroStatus;
    }

    public void setZeroStatus(String zeroStatus) {
        this.zeroStatus = zeroStatus;
    }

    public String getCalibratedAdValue() {
        return calibratedAdValue;
    }

    public void setCalibratedAdValue(String calibratedAdValue) {
        this.calibratedAdValue = calibratedAdValue;
    }

    public String getCalibrationStatus() {
        return calibrationStatus;
    }

    public void setCalibrationStatus(String calibrationStatus) {
        this.calibrationStatus = calibrationStatus;
    }

    public String getConcentration() {
        return concentration;
    }

    public void setConcentration(String concentration) {
        this.concentration = concentration;
    }

    public Integer getRealTimeAd() {
        return realTimeAd;
    }

    public void setRealTimeAd(Integer realTimeAd) {
        this.realTimeAd = realTimeAd;
    }

    public String getRealTimeStatus() {
        return realTimeStatus;
    }

    public void setRealTimeStatus(String realTimeStatus) {
        this.realTimeStatus = realTimeStatus;
    }
}
