package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 老化层点位信息对象 t_point_info
 * 
 * @author zehong
 * @date 2025-06-06
 */
public class TPointInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 点位ID */
    private Long fPointId;

    /** 所属托盘ID */
    @Excel(name = "所属托盘ID")
    private Long fTrayId;

    /** 点位编号 */
    @Excel(name = "点位编号")
    private String fPointCode;

    /** 绑定PCBA设备号 */
    @Excel(name = "绑定PCBA设备号")
    private String fPcbaCode;

    /** 点位状态：0在线，1离线，2故障 */
    @Excel(name = "点位状态：0在线，1离线，2故障")
    private String fStatus;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fCreateTime;

    /** 板子状态：0预热，1正常，3传感器故障，4报警，5通讯故障 */
    @Excel(name = "板子状态：0预热，1正常，3传感器故障，4报警，5通讯故障")
    private String fPcbaStatus;

    /** 绑定时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "绑定时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fBindingTime;

    /** 解绑时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "解绑时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fUnbindingTime;

    /** 上料时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "上料时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fLoadingTime;

    public void setfPointId(Long fPointId) 
    {
        this.fPointId = fPointId;
    }

    public Long getfPointId() 
    {
        return fPointId;
    }
    public void setfTrayId(Long fTrayId) 
    {
        this.fTrayId = fTrayId;
    }

    public Long getfTrayId() 
    {
        return fTrayId;
    }
    public void setfPointCode(String fPointCode) 
    {
        this.fPointCode = fPointCode;
    }

    public String getfPointCode() 
    {
        return fPointCode;
    }
    public void setfPcbaCode(String fPcbaCode) 
    {
        this.fPcbaCode = fPcbaCode;
    }

    public String getfPcbaCode() 
    {
        return fPcbaCode;
    }
    public void setfStatus(String fStatus) 
    {
        this.fStatus = fStatus;
    }

    public String getfStatus() 
    {
        return fStatus;
    }
    public void setfCreateTime(Date fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public Date getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfPcbaStatus(String fPcbaStatus) 
    {
        this.fPcbaStatus = fPcbaStatus;
    }

    public String getfPcbaStatus() 
    {
        return fPcbaStatus;
    }
    public void setfBindingTime(Date fBindingTime) 
    {
        this.fBindingTime = fBindingTime;
    }

    public Date getfBindingTime() 
    {
        return fBindingTime;
    }
    public void setfUnbindingTime(Date fUnbindingTime) 
    {
        this.fUnbindingTime = fUnbindingTime;
    }

    public Date getfUnbindingTime() 
    {
        return fUnbindingTime;
    }
    public void setfLoadingTime(Date fLoadingTime) 
    {
        this.fLoadingTime = fLoadingTime;
    }

    public Date getfLoadingTime() 
    {
        return fLoadingTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fPointId", getfPointId())
            .append("fTrayId", getfTrayId())
            .append("fPointCode", getfPointCode())
            .append("fPcbaCode", getfPcbaCode())
            .append("fStatus", getfStatus())
            .append("fCreateTime", getfCreateTime())
            .append("fPcbaStatus", getfPcbaStatus())
            .append("fBindingTime", getfBindingTime())
            .append("fUnbindingTime", getfUnbindingTime())
            .append("fLoadingTime", getfLoadingTime())
            .toString();
    }
}
