package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 托盘绑定的设备列对象 t_pallet_device_binding
 * 
 * @author zehong
 * @date 2025-06-29
 */
public class PalletDeviceBinding extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 托盘id */
    private Long palletDeviceBindingId;

    /** 托盘id */
    @Excel(name = "托盘id")
    private Long trayId;

    /** 托盘编号 */
    private String fTrayCode;

    /** 绑定的设备编号 */
    @Excel(name = "绑定的设备编号")
    private String deviceCode;

    /** 行 */
    @Excel(name = "行")
    private Integer row;

    /** 列 */
    @Excel(name = "列")
    private Integer col;

    /**
     * 第几个
     */
    private Integer index;

    /**
     * 顺序号
     */
    private Integer number;

    /** 绑定时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "绑定时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date bindingTime;

    /** 解绑时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "解绑时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date unbindingTime;

    /**
     * 状态 0-预热；1-正常;3-传感器故障;4-报警；5-通讯故障
     */
    private String status;

    /**
     * modbus 通信设置时间 年
     */
    private String recordYear;

    /**
     * modbus 通信设置时间 月
     */
    private String recordMonth;

    /**
     * modbus 通信设置时间 日
     */
    private String recordDate;

    /**
     * modbus 通信设置时间 时
     */
    private String recordHour;

    /**
     * modbus 通信设置时间 分
     */
    private String recordMinute;

    /**
     * 写时间状态 0-失败;1-成功
     */
    private String writeTimeStatus;

    /**
     * 零点校准AD
     */
    private String adjustmentZeroAd;

    /**
     * 零点校准AD
     */
    private String calibrationAd;

    /**
     * 浓度
     */
    private String concentration;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setPalletDeviceBindingId(Long palletDeviceBindingId)
    {
        this.palletDeviceBindingId = palletDeviceBindingId;
    }

    public Long getPalletDeviceBindingId() 
    {
        return palletDeviceBindingId;
    }
    public void setTrayId(Long trayId) 
    {
        this.trayId = trayId;
    }

    public Long getTrayId() 
    {
        return trayId;
    }
    public void setDeviceCode(String deviceCode) 
    {
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode() 
    {
        return deviceCode;
    }
    public void setRow(Integer row) 
    {
        this.row = row;
    }

    public Integer getRow() 
    {
        return row;
    }
    public void setCol(Integer col) 
    {
        this.col = col;
    }

    public Integer getCol() 
    {
        return col;
    }
    public void setBindingTime(Date bindingTime) 
    {
        this.bindingTime = bindingTime;
    }

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Date getBindingTime()
    {
        return bindingTime;
    }
    public void setUnbindingTime(Date unbindingTime) 
    {
        this.unbindingTime = unbindingTime;
    }

    public Date getUnbindingTime() 
    {
        return unbindingTime;
    }

    public String getRecordYear() {
        return recordYear;
    }

    public void setRecordYear(String recordYear) {
        this.recordYear = recordYear;
    }

    public String getRecordMonth() {
        return recordMonth;
    }

    public void setRecordMonth(String recordMonth) {
        this.recordMonth = recordMonth;
    }

    public String getRecordDate() {
        return recordDate;
    }

    public void setRecordDate(String recordDate) {
        this.recordDate = recordDate;
    }

    public String getRecordHour() {
        return recordHour;
    }

    public void setRecordHour(String recordHour) {
        this.recordHour = recordHour;
    }

    public String getRecordMinute() {
        return recordMinute;
    }

    public void setRecordMinute(String recordMinute) {
        this.recordMinute = recordMinute;
    }

    public String getWriteTimeStatus() {
        return writeTimeStatus;
    }

    public void setWriteTimeStatus(String writeTimeStatus) {
        this.writeTimeStatus = writeTimeStatus;
    }

    public String getAdjustmentZeroAd() {
        return adjustmentZeroAd;
    }

    public void setAdjustmentZeroAd(String adjustmentZeroAd) {
        this.adjustmentZeroAd = adjustmentZeroAd;
    }

    public String getCalibrationAd() {
        return calibrationAd;
    }

    public void setCalibrationAd(String calibrationAd) {
        this.calibrationAd = calibrationAd;
    }

    public String getConcentration() {
        return concentration;
    }

    public void setConcentration(String concentration) {
        this.concentration = concentration;
    }

    public String getfTrayCode() {
        return fTrayCode;
    }

    public void setfTrayCode(String fTrayCode) {
        this.fTrayCode = fTrayCode;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("palletDeviceBindingId", getPalletDeviceBindingId())
            .append("trayId", getTrayId())
            .append("deviceCode", getDeviceCode())
            .append("row", getRow())
            .append("col", getCol())
            .append("bindingTime", getBindingTime())
            .append("unbindingTime", getUnbindingTime())
            .append("createTime", getCreateTime())
            .toString();
    }
}
