package com.zehong.web.controller.equipment;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TStoreyInfo;
import com.zehong.system.service.ITStoreyInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 老化层信息Controller
 * 
 * @author zehong
 * @date 2025-05-28
 */
@RestController
@RequestMapping("/storey")
public class TStoreyInfoController extends BaseController
{
    @Autowired
    private ITStoreyInfoService tStoreyInfoService;

    /**
     * 查询老化层信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TStoreyInfo tStoreyInfo)
    {
        startPage();
        List<TStoreyInfo> list = tStoreyInfoService.selectTStoreyInfoList(tStoreyInfo);
        return getDataTable(list);
    }

    /**
     * 导出老化层信息列表
     */
    @Log(title = "老化层信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TStoreyInfo tStoreyInfo)
    {
        List<TStoreyInfo> list = tStoreyInfoService.selectTStoreyInfoList(tStoreyInfo);
        ExcelUtil<TStoreyInfo> util = new ExcelUtil<TStoreyInfo>(TStoreyInfo.class);
        return util.exportExcel(list, "老化层信息数据");
    }

    /**
     * 获取老化层信息详细信息
     */
    @GetMapping(value = "/queryByDepartmentId/{fEquipmentId}")
    public AjaxResult queryByDepartmentId(@PathVariable("fEquipmentId") Long fEquipmentId)
    {
        return AjaxResult.success(tStoreyInfoService.queryByDepartmentId(fEquipmentId));
    }

    /**
     * 给设备上电
     */
    @GetMapping(value = "/powerOn")
    public AjaxResult powerOn(TStoreyInfo tStoreyInfo) {
        return tStoreyInfoService.powerOn(tStoreyInfo);
    }

    /**
     * 给设备上电
     */
    @GetMapping(value = "/powerOutage")
    public AjaxResult powerOutage(TStoreyInfo tStoreyInfo) {
        return tStoreyInfoService.powerOutage(tStoreyInfo);
    }

    /**
     * 处理喂食
     */
    @GetMapping(value = "/handleFeeding/{command}")
    public AjaxResult handleFeeding(@PathVariable("command") String command) {
        return tStoreyInfoService.handleFeeding(command);
    }

    /**
     * 处理消 blanking
     */
    @GetMapping(value = "/handleBlanking/{command}")
    public AjaxResult handleBlanking(@PathVariable("command") String command) {
        return tStoreyInfoService.handleBlanking(command);
    }

    /**
     * 处理再老化
     */
    @GetMapping(value = "/handleReAgine")
    public AjaxResult handleReAgine(TStoreyInfo tStoreyInfo) {
        return tStoreyInfoService.handleReAgine(tStoreyInfo);
    }

    /**
     * 处理直接消 blanking
     */
    @GetMapping(value = "/handleDirectBlanking/{command}")
    public AjaxResult handleDirectBlanking(@PathVariable("command") String command) {
        return tStoreyInfoService.handleDirectBlanking(command);
    }

    /**
     * 批量读取老化柜状态
     */
    @GetMapping(value = "/batchReadingCabinetStatus/{fEquipmentCode}")
    public AjaxResult batchReadingCabinetStatus(@PathVariable("fEquipmentCode") String fEquipmentCode) {
        return tStoreyInfoService.batchReadingCabinetStatus(fEquipmentCode);
    }

    /**
     * 批量读取寄存器
     */
    @GetMapping(value = "/handleReadingHoldingRegister/{ipAndPort}")
    public AjaxResult handleReadingHoldingRegister(@PathVariable("ipAndPort") String ipAndPort) {
        return tStoreyInfoService.handleReadingHoldingRegister(ipAndPort);
    }

    /**
     * 给所有设备下电
     */
    @GetMapping(value = "/powerOffAllStore")
    public AjaxResult powerOffAllStore() {
        return tStoreyInfoService.powerOffAllStore();
    }
    /**
     * 指定设备下电 逗号分隔
     */
    @GetMapping(value = "/designatedDevicePowerOff/{equipmentCode}")
    public AjaxResult designatedDevicePowerOff(@PathVariable("equipmentCode") String equipmentCode) {
        return tStoreyInfoService.designatedDevicePowerOff(equipmentCode);
    }

    /**
     * 批量扫描并开始老化
     */
    @GetMapping(value = "/scanAndStartAgingAllCabinetLayers")
    public AjaxResult scanAndStartAgingAllCabinetLayers() {
        return tStoreyInfoService.scanAndStartAgingAllCabinetLayers();
    }

    /**
     * 给所有设备上电
     */
    @GetMapping(value = "/powerOnAllStore")
    public AjaxResult powerOnAllStore() {
        return tStoreyInfoService.powerOnAllStore();
    }

    /**
     * 指定设备上电 逗号分隔
     */
    @GetMapping(value = "/designatedDevicePowerOn/{equipmentCode}")
    public AjaxResult designatedDevicePowerOn(@PathVariable("equipmentCode") String equipmentCode) {
        return tStoreyInfoService.designatedDevicePowerOn(equipmentCode);
    }

    /**
     * 获取老化层信息详细信息
     */
    @GetMapping(value = "/{fStoreyId}")
    public AjaxResult getInfo(@PathVariable("fStoreyId") Long fStoreyId)
    {
        return AjaxResult.success(tStoreyInfoService.selectTStoreyInfoById(fStoreyId));
    }

    /**
     * 新增老化层信息
     */
    @Log(title = "老化层信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TStoreyInfo tStoreyInfo)
    {
        return toAjax(tStoreyInfoService.insertTStoreyInfo(tStoreyInfo));
    }

    /**
     * 修改老化层信息
     */
    @Log(title = "老化层信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TStoreyInfo tStoreyInfo)
    {
        return toAjax(tStoreyInfoService.updateTStoreyInfo(tStoreyInfo));
    }

    /**
     * 删除老化层信息
     */
    @Log(title = "老化层信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fStoreyIds}")
    public AjaxResult remove(@PathVariable Long[] fStoreyIds)
    {
        return toAjax(tStoreyInfoService.deleteTStoreyInfoByIds(fStoreyIds));
    }
}
