package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEquipmentAlarmData;

/**
 * 生产设备报警信息Mapper接口
 * 
 * @author zehong
 * @date 2025-06-03
 */
public interface TEquipmentAlarmDataMapper 
{
    /**
     * 查询生产设备报警信息
     * 
     * @param fEquipmentAlarmDataId 生产设备报警信息ID
     * @return 生产设备报警信息
     */
    public TEquipmentAlarmData selectTEquipmentAlarmDataById(Long fEquipmentAlarmDataId);

    /**
     * 查询生产设备报警信息列表
     * 
     * @param tEquipmentAlarmData 生产设备报警信息
     * @return 生产设备报警信息集合
     */
    public List<TEquipmentAlarmData> selectTEquipmentAlarmDataList(TEquipmentAlarmData tEquipmentAlarmData);

    /**
     * 新增生产设备报警信息
     * 
     * @param tEquipmentAlarmData 生产设备报警信息
     * @return 结果
     */
    public int insertTEquipmentAlarmData(TEquipmentAlarmData tEquipmentAlarmData);

    /**
     * 修改生产设备报警信息
     * 
     * @param tEquipmentAlarmData 生产设备报警信息
     * @return 结果
     */
    public int updateTEquipmentAlarmData(TEquipmentAlarmData tEquipmentAlarmData);

    /**
     * 删除生产设备报警信息
     * 
     * @param fEquipmentAlarmDataId 生产设备报警信息ID
     * @return 结果
     */
    public int deleteTEquipmentAlarmDataById(Long fEquipmentAlarmDataId);

    /**
     * 批量删除生产设备报警信息
     * 
     * @param fEquipmentAlarmDataIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEquipmentAlarmDataByIds(Long[] fEquipmentAlarmDataIds);
}
