package com.zehong.web.controller.equipment;

import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.system.domain.TEquipmentAlarmData;
import com.zehong.system.service.ITEquipmentAlarmDataService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lenovo
 * @date 2025/11/12
 * @description 报警历史记录
 */
@RestController
@RequestMapping("/equipmentAlarmData/record")
public class TEquipmentAlarmDataController extends BaseController {

    @Resource
    private ITEquipmentAlarmDataService tEquipmentAlarmDataService;

    @RequestMapping("/list")
    public TableDataInfo list(TEquipmentAlarmData tEquipmentAlarmData) {
        startPage();
        List<TEquipmentAlarmData> list = tEquipmentAlarmDataService.selectTEquipmentAlarmDataList(tEquipmentAlarmData);
        return getDataTable(list);
    }
}
