package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TPointInfo;

/**
 * 老化层点位信息Mapper接口
 * 
 * @author zehong
 * @date 2025-06-06
 */
public interface TPointInfoMapper 
{
    /**
     * 查询老化层点位信息
     * 
     * @param fPointId 老化层点位信息ID
     * @return 老化层点位信息
     */
    public TPointInfo selectTPointInfoById(Long fPointId);

    /**
     * 查询老化层点位信息列表
     * 
     * @param tPointInfo 老化层点位信息
     * @return 老化层点位信息集合
     */
    public List<TPointInfo> selectTPointInfoList(TPointInfo tPointInfo);

    /**
     * 新增老化层点位信息
     * 
     * @param tPointInfo 老化层点位信息
     * @return 结果
     */
    public int insertTPointInfo(TPointInfo tPointInfo);

    /**
     * 修改老化层点位信息
     * 
     * @param tPointInfo 老化层点位信息
     * @return 结果
     */
    public int updateTPointInfo(TPointInfo tPointInfo);

    /**
     * 删除老化层点位信息
     * 
     * @param fPointId 老化层点位信息ID
     * @return 结果
     */
    public int deleteTPointInfoById(Long fPointId);

    /**
     * 批量删除老化层点位信息
     * 
     * @param fPointIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPointInfoByIds(Long[] fPointIds);
}
