package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 生产设备报警信息对象 t_equipment_alarm_data
 * 
 * @author zehong
 * @date 2025-06-03
 */
public class TEquipmentAlarmData extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long fEquipmentAlarmDataId;

    /** 报警设备编号 */
    @Excel(name = "报警设备编号")
    private String fEquipmentCode;

    /** 报警类型 */
    @Excel(name = "报警类型")
    private String fAlarmType;

    /** 报警数据 */
    @Excel(name = "报警数据")
    private String fAlarmData;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fCreateTime;

    public void setfEquipmentAlarmDataId(Long fEquipmentAlarmDataId) 
    {
        this.fEquipmentAlarmDataId = fEquipmentAlarmDataId;
    }

    public Long getfEquipmentAlarmDataId() 
    {
        return fEquipmentAlarmDataId;
    }
    public void setfEquipmentCode(String fEquipmentCode)
    {
        this.fEquipmentCode = fEquipmentCode;
    }

    public String getfEquipmentCode() 
    {
        return fEquipmentCode;
    }
    public void setfAlarmType(String fAlarmType) 
    {
        this.fAlarmType = fAlarmType;
    }

    public String getfAlarmType() 
    {
        return fAlarmType;
    }
    public void setfAlarmData(String fAlarmData) 
    {
        this.fAlarmData = fAlarmData;
    }

    public String getfAlarmData() 
    {
        return fAlarmData;
    }
    public void setfCreateTime(Date fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public Date getfCreateTime() 
    {
        return fCreateTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fEquipmentAlarmDataId", getfEquipmentAlarmDataId())
            .append("fEquipmentCode", getfEquipmentCode())
            .append("fAlarmType", getfAlarmType())
            .append("fAlarmData", getfAlarmData())
            .append("fCreateTime", getfCreateTime())
            .toString();
    }
}
