package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 托盘绑定的设备列对象 t_pallet_device_binding
 *
 * @author zehong
 * @date 2025-06-29
 */
public class PalletDeviceBinding extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 托盘id */
    private Long palletDeviceBindingId;

    /** 托盘id */
    @Excel(name = "托盘id")
    private Long trayId;

    /** 托盘编号 */
    private String fTrayCode;

    /** 绑定的设备编号 */
    @Excel(name = "绑定的设备编号")
    private String deviceCode;

    /** 行 */
    @Excel(name = "行")
    private Integer row;

    /** 列 */
    @Excel(name = "列")
    private Integer col;

    /**
     * 第几个
     */
    private Integer index;

    /**
     * 顺序号
     */
    private Integer number;

    /** 绑定时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "绑定时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date bindingTime;

    /** 解绑时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "解绑时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date unbindingTime;

    /**
     * 状态 0-预热；1-正常;3-传感器故障;4-报警；5-通讯故障
     */
    private String status;

    /**
     * modbus 通信设置时间 年
     */
    private String recordYear;

    /**
     * modbus 通信设置时间 月
     */
    private String recordMonth;

    /**
     * modbus 通信设置时间 日
     */
    private String recordDate;

    /**
     * modbus 通信设置时间 时
     */
    private String recordHour;

    /**
     * modbus 通信设置时间 分
     */
    private String recordMinute;

    /**
     * 写时间状态 0-失败;1-成功
     */
    private String writeTimeStatus;

    /**
     * 零点AD
     */
    private String adjustmentZeroAd;

    /**
     * 零点状态 0-异常;1-正常
     */
    private String zeroStatus;

    /**
     * 校准AD
     */
    private String calibrationAd;

    /**
     * 校准AD状态 0-异常;1-正常
     */
    private String calibrationAdStatus;

    /**
     * 浓度
     */
    private String concentration;


    /**
     * 运行时间状态 0-异常;1-正常
     */
    private String runTimeStatus;

    /**
     * 实时AD
     */
    private Integer realTimeAd;

    /**
     * 实时状态 0-异常;1-正常
     */
    private String realTimeStatus;

    /**
     * 标定浓度值
     */
    private BigDecimal calibrationConcentration;

    /**
     * 标定状态 4-正常，其他都是异常
     * 0-预热；1-正常；3-传感器故障；4-报警；5-通讯故障； 只有是4的时候显示正常，其他的都是异常
     */
    private String calibrationConcentrationStatus;

    /**
     * 写自检状态 空 是没写 0-失败;1-成功
     */
    private Integer writeSelfCheckStatus;

    /**
     * 继电器状态 0：初始 1：动作
     */
    private Integer relayStatus;

    /**
     * 脉冲状态 0：初始 1：动作
     */
    private Integer pulseStatus;

    /**
     * 模块状态 0：异常 1：正常
     */
    private Integer moduleStatus;

    /**
     * SIM卡状态 0：异常 1：正常
     */
    private Integer simCardStatus;

    /**
     * 网络状态 0：异常 1：正常
     */
    private Integer networkStatus;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setPalletDeviceBindingId(Long palletDeviceBindingId)
    {
        this.palletDeviceBindingId = palletDeviceBindingId;
    }

    public Long getPalletDeviceBindingId()
    {
        return palletDeviceBindingId;
    }
    public void setTrayId(Long trayId)
    {
        this.trayId = trayId;
    }

    public Long getTrayId()
    {
        return trayId;
    }
    public void setDeviceCode(String deviceCode)
    {
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode()
    {
        return deviceCode;
    }
    public void setRow(Integer row)
    {
        this.row = row;
    }

    public Integer getRow()
    {
        return row;
    }
    public void setCol(Integer col)
    {
        this.col = col;
    }

    public Integer getCol()
    {
        return col;
    }
    public void setBindingTime(Date bindingTime)
    {
        this.bindingTime = bindingTime;
    }

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Date getBindingTime()
    {
        return bindingTime;
    }
    public void setUnbindingTime(Date unbindingTime)
    {
        this.unbindingTime = unbindingTime;
    }

    public Date getUnbindingTime()
    {
        return unbindingTime;
    }

    public String getRecordYear() {
        return recordYear;
    }

    public void setRecordYear(String recordYear) {
        this.recordYear = recordYear;
    }

    public String getRecordMonth() {
        return recordMonth;
    }

    public void setRecordMonth(String recordMonth) {
        this.recordMonth = recordMonth;
    }

    public String getRecordDate() {
        return recordDate;
    }

    public void setRecordDate(String recordDate) {
        this.recordDate = recordDate;
    }

    public String getRecordHour() {
        return recordHour;
    }

    public void setRecordHour(String recordHour) {
        this.recordHour = recordHour;
    }

    public String getRecordMinute() {
        return recordMinute;
    }

    public void setRecordMinute(String recordMinute) {
        this.recordMinute = recordMinute;
    }

    public String getWriteTimeStatus() {
        return writeTimeStatus;
    }

    public void setWriteTimeStatus(String writeTimeStatus) {
        this.writeTimeStatus = writeTimeStatus;
    }

    public String getAdjustmentZeroAd() {
        return adjustmentZeroAd;
    }

    public void setAdjustmentZeroAd(String adjustmentZeroAd) {
        this.adjustmentZeroAd = adjustmentZeroAd;
    }

    public String getCalibrationAd() {
        return calibrationAd;
    }

    public void setCalibrationAd(String calibrationAd) {
        this.calibrationAd = calibrationAd;
    }

    public String getConcentration() {
        return concentration;
    }

    public void setConcentration(String concentration) {
        this.concentration = concentration;
    }

    public String getfTrayCode() {
        return fTrayCode;
    }

    public void setfTrayCode(String fTrayCode) {
        this.fTrayCode = fTrayCode;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getRunTimeStatus() {
        return runTimeStatus;
    }

    public void setRunTimeStatus(String runTimeStatus) {
        this.runTimeStatus = runTimeStatus;
    }

    public Integer getRealTimeAd() {
        return realTimeAd;
    }

    public String getRealTimeStatus() {
        return realTimeStatus;
    }

    public void setRealTimeStatus(String realTimeStatus) {
        this.realTimeStatus = realTimeStatus;
    }

    public String getZeroStatus() {
        return zeroStatus;
    }

    public void setZeroStatus(String zeroStatus) {
        this.zeroStatus = zeroStatus;
    }

    public String getCalibrationAdStatus() {
        return calibrationAdStatus;
    }

    public void setCalibrationAdStatus(String calibrationAdStatus) {
        this.calibrationAdStatus = calibrationAdStatus;
    }

    public BigDecimal getCalibrationConcentration() {
        return calibrationConcentration;
    }

    public void setCalibrationConcentration(BigDecimal calibrationConcentration) {
        this.calibrationConcentration = calibrationConcentration;
    }

    public String getCalibrationConcentrationStatus() {
        return calibrationConcentrationStatus;
    }

    public void setCalibrationConcentrationStatus(String calibrationConcentrationStatus) {
        this.calibrationConcentrationStatus = calibrationConcentrationStatus;
    }

    public void setRealTimeAd(Integer realTimeAd) {
        this.realTimeAd = realTimeAd;
    }

    public Integer getWriteSelfCheckStatus() {
        return writeSelfCheckStatus;
    }

    public void setWriteSelfCheckStatus(Integer writeSelfCheckStatus) {
        this.writeSelfCheckStatus = writeSelfCheckStatus;
    }

    public Integer getRelayStatus() {
        return relayStatus;
    }

    public void setRelayStatus(Integer relayStatus) {
        this.relayStatus = relayStatus;
    }

    public Integer getPulseStatus() {
        return pulseStatus;
    }

    public void setPulseStatus(Integer pulseStatus) {
        this.pulseStatus = pulseStatus;
    }

    public Integer getModuleStatus() {
        return moduleStatus;
    }

    public void setModuleStatus(Integer moduleStatus) {
        this.moduleStatus = moduleStatus;
    }

    public Integer getSimCardStatus() {
        return simCardStatus;
    }

    public void setSimCardStatus(Integer simCardStatus) {
        this.simCardStatus = simCardStatus;
    }

    public Integer getNetworkStatus() {
        return networkStatus;
    }

    public void setNetworkStatus(Integer networkStatus) {
        this.networkStatus = networkStatus;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("palletDeviceBindingId", getPalletDeviceBindingId())
                .append("trayId", getTrayId())
                .append("fTrayCode", getfTrayCode())
                .append("deviceCode", getDeviceCode())
                .append("row", getRow())
                .append("col", getCol())
                .append("index", getIndex())
                .append("number", getNumber())
                .append("bindingTime", getBindingTime())
                .append("unbindingTime", getUnbindingTime())
                .append("status", getStatus())
                .append("recordYear", getRecordYear())
                .append("recordMonth", getRecordMonth())
                .append("recordDate", getRecordDate())
                .append("recordHour", getRecordHour())
                .append("recordMinute", getRecordMinute())
                .append("writeTimeStatus", getWriteTimeStatus())
                .append("adjustmentZeroAd", getAdjustmentZeroAd())
                .append("zeroStatus", getZeroStatus())
                .append("calibrationAd", getCalibrationAd())
                .append("calibrationAdStatus", getCalibrationAdStatus())
                .append("concentration", getConcentration())
                .append("runTimeStatus", getRunTimeStatus())
                .append("realTimeAd", getRealTimeAd())
                .append("realTimeStatus", getRealTimeStatus())
                .append("calibrationConcentration", getCalibrationConcentration())
                .append("calibrationConcentrationStatus", getCalibrationConcentrationStatus())
                .append("writeSelfCheckStatus", getWriteSelfCheckStatus())
                .append("relayStatus", getRelayStatus())
                .append("pulseStatus", getPulseStatus())
                .append("moduleStatus", getModuleStatus())
                .append("simCardStatus", getSimCardStatus())
                .append("networkStatus", getNetworkStatus())
                .append("createTime", getCreateTime())
                .append("updateTime", getUpdateTime())
                .append("createBy", getCreateBy())
                .append("updateBy", getUpdateBy())
                .toString();
    }
}
