package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 上传失败历史记录对象 t_pallet_device_upload_failure
 *
 * @author zehong
 * @date 2026-01-16
 */
public class PalletDeviceUploadFailure extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 托盘id */
    private Long id;

    /** 托盘id */
    private Long trayId;
    /** 托盘编号 */
    @Excel(name = "托盘编号")
    private String trayCode;

    /** 绑定层编号 */
    @Excel(name = "绑定层编号")
    private String storeyCode;

    /** 绑定的设备编号 */
    @Excel(name = "绑定的设备编号")
    private String motherboardCode;

    /** 行 */
    @Excel(name = "行")
    private Integer row;

    /** 列 */
    @Excel(name = "列")
    private Integer col;

    /** 第几个 */
    @Excel(name = "第几个")
    private Integer index;

    /** 编号 */
    @Excel(name = "编号")
    private Integer number;

    /** 绑定时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "绑定时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date bindingTime;

    /** 解绑时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date unbindingTime;

    /** 0-预热；1-正常;3-传感器故障;4-报警；5-通讯故障 -9999通讯异常*/
    @Excel(name = "0-预热；1-正常;3-传感器故障;4-报警；5-通讯故障；-9999-通讯异常")
    private String deviceStatus;

    /** 设置-年 */
    @Excel(name = "设置-年")
    private String recordYear;

    /** 设置-月 */
    @Excel(name = "设置-月")
    private String recordMonth;

    /** 设置-日 */
    @Excel(name = "设置-日")
    private String recordDate;

    /** 设置-时 */
    @Excel(name = "设置-时")
    private String recordHour;

    /** 设置-分 */
    @Excel(name = "设置-分")
    private String recordMinute;

    /** 写入时间状态;0-失败;1-成功 */
    @Excel(name = "写入时间状态;0-失败;1-成功")
    private String writeTimeStatus;

    /** 调零AD */
    @Excel(name = "调零AD")
    private String adjustmentZeroAd;

    /** 合格；不合格 */
    @Excel(name = "合格；不合格")
    private String zeroStatus;

    /** 标定AD */
    @Excel(name = "标定AD")
    private String calibrationAd;

    /** 合格；不合格 */
    @Excel(name = "合格；不合格")
    private String calibrationAdStatus;

    /** 浓度值 */
    @Excel(name = "浓度值")
    private String concentration;

    /** 写入时间状态;0-失败;1-成功 */
    @Excel(name = "写入时间状态;0-失败;1-成功")
    private String runTimeStatus;

    /** 实时AD值 */
    @Excel(name = "实时AD值")
    private Integer realTimeAd;

    /** 实时AD状态;0-异常;1-正常 */
    @Excel(name = "实时AD状态;0-异常;1-正常")
    private String realTimeStatus;

    /** 标定浓度值 */
    @Excel(name = "标定浓度值")
    private BigDecimal calibrationConcentration;

    /** 标定浓度状态(0-预热；1-正常；3-传感器故障；4-报警；5-通讯故障； 只有是4的时候显示正常，其他的都是异常) */
    @Excel(name = "标定浓度状态(0-预热；1-正常；3-传感器故障；4-报警；5-通讯故障； 只有是4的时候显示正常，其他的都是异常)")
    private String calibrationConcentrationStatus;

    /** 写入自检状态(可以是空，0-失败，1-成功) */
    @Excel(name = "写入自检状态(可以是空，0-失败，1-成功)")
    private Integer writeSelfCheckStatus;

    /** 继电器状态(0-初始，1-动作) */
    @Excel(name = "继电器状态(0-初始，1-动作)")
    private Integer relayStatus;

    /** 脉冲状态(0-初始，1-动作) */
    @Excel(name = "脉冲状态(0-初始，1-动作)")
    private Integer pulseStatus;

    /** 模组状态(0-异常，1-正常) */
    @Excel(name = "模组状态(0-异常，1-正常)")
    private Integer moduleStatus;

    /** SIM卡状态(0-异常，1-正常) */
    @Excel(name = "SIM卡状态(0-异常，1-正常)")
    private Integer simCardStatus;

    /** 网络状态(0-异常，1-正常) */
    @Excel(name = "网络状态(0-异常，1-正常)")
    private Integer networkStatus;

    /** 产品标准检验编号 */
    @Excel(name = "标检单号")
    private String productStandardInspectionNumber;

    /** 标检结果 */
    private String standardInspectResult;

    /** 板件类型：1.主体 2.主板*/
    private String plateType;
    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setTrayId(Long trayId)
    {
        this.trayId = trayId;
    }

    public Long getTrayId()
    {
        return trayId;
    }
    public void setStoreyCode(String storeyCode)
    {
        this.storeyCode = storeyCode;
    }

    public String getStoreyCode()
    {
        return storeyCode;
    }

    public String getMotherboardCode() {
        return motherboardCode;
    }

    public void setMotherboardCode(String motherboardCode) {
        this.motherboardCode = motherboardCode;
    }

    public void setRow(Integer row)
    {
        this.row = row;
    }

    public Integer getRow()
    {
        return row;
    }
    public void setCol(Integer col)
    {
        this.col = col;
    }

    public Integer getCol()
    {
        return col;
    }
    public void setIndex(Integer index)
    {
        this.index = index;
    }

    public Integer getIndex()
    {
        return index;
    }
    public void setNumber(Integer number)
    {
        this.number = number;
    }

    public Integer getNumber()
    {
        return number;
    }
    public void setBindingTime(Date bindingTime)
    {
        this.bindingTime = bindingTime;
    }

    public Date getBindingTime()
    {
        return bindingTime;
    }
    public void setUnbindingTime(Date unbindingTime)
    {
        this.unbindingTime = unbindingTime;
    }

    public Date getUnbindingTime()
    {
        return unbindingTime;
    }

    public String getDeviceStatus() {
        return deviceStatus;
    }

    public void setDeviceStatus(String deviceStatus) {
        this.deviceStatus = deviceStatus;
    }

    public void setRecordYear(String recordYear)
    {
        this.recordYear = recordYear;
    }

    public String getRecordYear()
    {
        return recordYear;
    }
    public void setRecordMonth(String recordMonth)
    {
        this.recordMonth = recordMonth;
    }

    public String getRecordMonth()
    {
        return recordMonth;
    }
    public void setRecordDate(String recordDate)
    {
        this.recordDate = recordDate;
    }

    public String getRecordDate()
    {
        return recordDate;
    }
    public void setRecordHour(String recordHour)
    {
        this.recordHour = recordHour;
    }

    public String getRecordHour()
    {
        return recordHour;
    }
    public void setRecordMinute(String recordMinute)
    {
        this.recordMinute = recordMinute;
    }

    public String getRecordMinute()
    {
        return recordMinute;
    }
    public void setWriteTimeStatus(String writeTimeStatus)
    {
        this.writeTimeStatus = writeTimeStatus;
    }

    public String getWriteTimeStatus()
    {
        return writeTimeStatus;
    }
    public void setAdjustmentZeroAd(String adjustmentZeroAd)
    {
        this.adjustmentZeroAd = adjustmentZeroAd;
    }

    public String getAdjustmentZeroAd()
    {
        return adjustmentZeroAd;
    }
    public void setZeroStatus(String zeroStatus)
    {
        this.zeroStatus = zeroStatus;
    }

    public String getZeroStatus()
    {
        return zeroStatus;
    }
    public void setCalibrationAd(String calibrationAd)
    {
        this.calibrationAd = calibrationAd;
    }

    public String getCalibrationAd()
    {
        return calibrationAd;
    }

    public String getCalibrationAdStatus() {
        return calibrationAdStatus;
    }

    public void setCalibrationAdStatus(String calibrationAdStatus) {
        this.calibrationAdStatus = calibrationAdStatus;
    }

    public void setConcentration(String concentration)
    {
        this.concentration = concentration;
    }

    public String getConcentration()
    {
        return concentration;
    }
    public void setRunTimeStatus(String runTimeStatus)
    {
        this.runTimeStatus = runTimeStatus;
    }

    public String getRunTimeStatus()
    {
        return runTimeStatus;
    }
    public void setRealTimeAd(Integer realTimeAd)
    {
        this.realTimeAd = realTimeAd;
    }

    public Integer getRealTimeAd()
    {
        return realTimeAd;
    }

    public String getRealTimeStatus() {
        return realTimeStatus;
    }

    public void setRealTimeStatus(String realTimeStatus) {
        this.realTimeStatus = realTimeStatus;
    }

    public void setCalibrationConcentration(BigDecimal calibrationConcentration)
    {
        this.calibrationConcentration = calibrationConcentration;
    }

    public BigDecimal getCalibrationConcentration()
    {
        return calibrationConcentration;
    }
    public void setCalibrationConcentrationStatus(String calibrationConcentrationStatus)
    {
        this.calibrationConcentrationStatus = calibrationConcentrationStatus;
    }

    public String getCalibrationConcentrationStatus()
    {
        return calibrationConcentrationStatus;
    }
    public void setWriteSelfCheckStatus(Integer writeSelfCheckStatus)
    {
        this.writeSelfCheckStatus = writeSelfCheckStatus;
    }

    public Integer getWriteSelfCheckStatus()
    {
        return writeSelfCheckStatus;
    }
    public void setRelayStatus(Integer relayStatus)
    {
        this.relayStatus = relayStatus;
    }

    public Integer getRelayStatus()
    {
        return relayStatus;
    }
    public void setPulseStatus(Integer pulseStatus)
    {
        this.pulseStatus = pulseStatus;
    }

    public Integer getPulseStatus()
    {
        return pulseStatus;
    }
    public void setModuleStatus(Integer moduleStatus)
    {
        this.moduleStatus = moduleStatus;
    }

    public Integer getModuleStatus()
    {
        return moduleStatus;
    }
    public void setSimCardStatus(Integer simCardStatus)
    {
        this.simCardStatus = simCardStatus;
    }

    public Integer getSimCardStatus()
    {
        return simCardStatus;
    }
    public void setNetworkStatus(Integer networkStatus)
    {
        this.networkStatus = networkStatus;
    }

    public Integer getNetworkStatus()
    {
        return networkStatus;
    }

    public String getTrayCode() {
        return trayCode;
    }

    public void setTrayCode(String trayCode) {
        this.trayCode = trayCode;
    }

    public String getProductStandardInspectionNumber() {
        return productStandardInspectionNumber;
    }

    public void setProductStandardInspectionNumber(String productStandardInspectionNumber) {
        this.productStandardInspectionNumber = productStandardInspectionNumber;
    }

    public String getStandardInspectResult() {
        return standardInspectResult;
    }

    public void setStandardInspectResult(String standardInspectResult) {
        this.standardInspectResult = standardInspectResult;
    }

    public String getPlateType() {
        return plateType;
    }

    public void setPlateType(String plateType) {
        this.plateType = plateType;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("trayId", getTrayId())
            .append("storeyCode", getStoreyCode())
            .append("motherboardCode", getMotherboardCode())
            .append("row", getRow())
            .append("col", getCol())
            .append("index", getIndex())
            .append("number", getNumber())
            .append("bindingTime", getBindingTime())
            .append("unbindingTime", getUnbindingTime())
            .append("createTime", getCreateTime())
            .append("deviceStatus", getDeviceStatus())
            .append("recordYear", getRecordYear())
            .append("recordMonth", getRecordMonth())
            .append("recordDate", getRecordDate())
            .append("recordHour", getRecordHour())
            .append("recordMinute", getRecordMinute())
            .append("writeTimeStatus", getWriteTimeStatus())
            .append("adjustmentZeroAd", getAdjustmentZeroAd())
            .append("zeroStatus", getZeroStatus())
            .append("calibrationAd", getCalibrationAd())
            .append("calibrationAdStatus", getCalibrationAdStatus())
            .append("concentration", getConcentration())
            .append("runTimeStatus", getRunTimeStatus())
            .append("realTimeAd", getRealTimeAd())
            .append("realTimeStatus", getRealTimeStatus())
            .append("calibrationConcentration", getCalibrationConcentration())
            .append("calibrationConcentrationStatus", getCalibrationConcentrationStatus())
            .append("writeSelfCheckStatus", getWriteSelfCheckStatus())
            .append("relayStatus", getRelayStatus())
            .append("pulseStatus", getPulseStatus())
            .append("moduleStatus", getModuleStatus())
            .append("simCardStatus", getSimCardStatus())
            .append("networkStatus", getNetworkStatus())
            .append("trayCode", getTrayCode())
            .append("productStandardInspectionNumber", getProductStandardInspectionNumber())
            .append("standardInspectResult", getStandardInspectResult())
            .append("plateType", getPlateType())
            .toString();
    }
}
