package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TStoreyInfo;
import org.apache.ibatis.annotations.Param;

/**
 * 老化层信息Mapper接口
 * 
 * @author zehong
 * @date 2025-05-28
 */
public interface TStoreyInfoMapper 
{
    /**
     * 查询老化层信息
     * 
     * @param fStoreyId 老化层信息ID
     * @return 老化层信息
     */
    public TStoreyInfo selectTStoreyInfoById(Long fStoreyId);

    public TStoreyInfo selectByBlankingCommand(String blankingCommand);

    /**
     * 查询老化层信息
     *
     * @param fStoreyCode 老化层信息Code
     * @return 老化层信息
     */
    public TStoreyInfo selectTStoreyInfoByCode(String fStoreyCode);

    public void unbindByCode(TStoreyInfo tStoreyInfo);

    public void updateStatusByCode(TStoreyInfo tStoreyInfo);

    // 新增方法：查询离机械臂最近的空闲层
    public TStoreyInfo selectNearestFreeStorey();
    /**
     * 查询老化层信息列表
     * 
     * @param tStoreyInfo 老化层信息
     * @return 老化层信息集合
     */
    public List<TStoreyInfo> selectTStoreyInfoList(TStoreyInfo tStoreyInfo);

    public List<TStoreyInfo> selectByEquipmentIds(@Param("list") List<Long> fEquipmentIds);

    public List<TStoreyInfo> queryByDepartmentId(Long fEquipmentId);

    /**
     * 新增老化层信息
     * 
     * @param tStoreyInfo 老化层信息
     * @return 结果
     */
    public int insertTStoreyInfo(TStoreyInfo tStoreyInfo);

    public int insertBatch(@Param("storeyInfos") List<TStoreyInfo> storeyInfos);

    /**
     * 修改老化层信息
     * 
     * @param tStoreyInfo 老化层信息
     * @return 结果
     */
    public int updateTStoreyInfo(TStoreyInfo tStoreyInfo);

    public int updateAllStatusAndAgingStartTime(TStoreyInfo tStoreyInfo);

    public int updateBatch(@Param("storeyInfos") List<TStoreyInfo> storeyInfos);

    /**
     * 删除老化层信息
     * 
     * @param fStoreyId 老化层信息ID
     * @return 结果
     */
    public int deleteTStoreyInfoById(Long fStoreyId);

    /**
     * 批量删除老化层信息
     * 
     * @param fStoreyIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTStoreyInfoByIds(Long[] fStoreyIds);
}
