import request from '@/utils/request'

// 查询机械臂指令列表
export function listCommand(query) {
  return request({
    url: '/robotArm/command/list',
    method: 'get',
    params: query
  })
}

// 查询机械臂指令详细
export function getCommand(robotArmCommandId) {
  return request({
    url: '/robotArm/command/' + robotArmCommandId,
    method: 'get'
  })
}

// 新增机械臂指令
export function addCommand(data) {
  return request({
    url: '/robotArm/command',
    method: 'post',
    data: data
  })
}

// 新增机械臂指令
export function insertBlankingRobotArmCommand(data) {
  return request({
    url: '/robotArm/command/insertBlankingRobotArmCommand',
    method: 'post',
    data: data
  })
}

// 发送归位指令
export function sendHomeCommand() {
  return request({
    url: '/robotArm/command/sendHomeCommand',
    method: 'get'
  })
}


// 停止当前指令
export function sendStopCommand() {
  return request({
    url: '/robotArm/command/sendStopCommand',
    method: 'get'
  })
}


// 执行上电操作
export function powerOnCommand(commandId) {
  return request({
    url: '/robotArm/command/powerOn',
    method: 'post',
    data: { commandId }
  })
}

export function sureCompletedCommand(commandId) {
  return request({
    url: '/robotArm/command/sureCompletedCommand/' + commandId,
    method: 'get'
  })
}

// 修改机械臂指令
export function updateCommand(data) {
  return request({
    url: '/robotArm/command',
    method: 'put',
    data: data
  })
}

// 删除机械臂指令
export function delCommand(robotArmCommandId) {
  return request({
    url: '/robotArm/command/' + robotArmCommandId,
    method: 'delete'
  })
}

// 导出机械臂指令
export function exportCommand(query) {
  return request({
    url: '/robotArm/command/export',
    method: 'get',
    params: query
  })
}
