package com.zehong.system.netty;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;


/**
 * @author lenovo
 * @date 2025/7/31
 * @description Netty配置类
 */
@Configuration
public class NettyConfig {

    /**
     * 服务端口
     */
    @Value("${netty.port}")
    private int port;

    /**
     * 主线程数
     */
    @Value("${netty.boss-group-thread-count}")  // 注意配置文件中的横杠命名对应类中的驼峰命名
    private int bossGroupThreadCount = 1;

    /**
     * 工作线程数（从配置文件读取，默认值为CPU核心数*2）
     */
    @Value("${netty.worker-group-thread-count}")  // 新增配置映射
    private int workerGroupThreadCount;

    /**
     * 最大帧长度
     */
    @Value("${netty.max-frame-length}")  // 配置文件中的横杠对应类中的驼峰
    private int maxFrameLength;

    /**
     * 心跳检测超时时间(秒)
     */
    @Value("${netty.heartbeat-timeout}")  // 配置文件中的横杠对应类中的驼峰
    private int heartbeatTimeout;

    // getter和setter方法
    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getBossGroupThreadCount() {
        return bossGroupThreadCount;
    }

    public void setBossGroupThreadCount(int bossGroupThreadCount) {
        this.bossGroupThreadCount = bossGroupThreadCount;
    }

    public int getWorkerGroupThreadCount() {
        return workerGroupThreadCount;
    }

    public void setWorkerGroupThreadCount(int workerGroupThreadCount) {
        this.workerGroupThreadCount = workerGroupThreadCount;
    }

    public int getMaxFrameLength() {
        return maxFrameLength;
    }

    public void setMaxFrameLength(int maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
    }

    public int getHeartbeatTimeout() {
        return heartbeatTimeout;
    }

    public void setHeartbeatTimeout(int heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }
}
