package com.zehong.system.service.websocket;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

import javax.annotation.Resource;

/**
 * @author lenovo
 * @date 2025/8/14
 * @description 老化柜WebSocket配置类
 */
@Configuration
@EnableWebSocket
public class AgingCabinetWebSocketConfig implements WebSocketConfigurer {

    @Resource
    private AgingCabinetWebSocketHandler agingCabinetWebSocketHandler;

    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        // 注册处理器，设置访问路径为/ws-aging-cabinet，允许所有跨域
        registry.addHandler(agingCabinetWebSocketHandler, "/ws-aging-cabinet")
                .setAllowedOrigins("*");
    }
}