package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.UploadMesResultHistoryMapper;
import com.zehong.system.domain.UploadMesResultHistory;
import com.zehong.system.service.IUploadMesResultHistoryService;

import javax.annotation.Resource;

/**
 * 上传MES返回结果历史记录Service业务层处理
 * 
 * @author zehong
 * @date 2025-12-03
 */
@Service
public class UploadMesResultHistoryServiceImpl implements IUploadMesResultHistoryService 
{
    @Resource
    private UploadMesResultHistoryMapper uploadMesResultHistoryMapper;

    /**
     * 查询上传MES返回结果历史记录
     * 
     * @param id 上传MES返回结果历史记录ID
     * @return 上传MES返回结果历史记录
     */
    @Override
    public UploadMesResultHistory selectUploadMesResultHistoryById(Long id)
    {
        return uploadMesResultHistoryMapper.selectUploadMesResultHistoryById(id);
    }

    /**
     * 查询上传MES返回结果历史记录列表
     * 
     * @param uploadMesResultHistory 上传MES返回结果历史记录
     * @return 上传MES返回结果历史记录
     */
    @Override
    public List<UploadMesResultHistory> selectUploadMesResultHistoryList(UploadMesResultHistory uploadMesResultHistory)
    {
        return uploadMesResultHistoryMapper.selectUploadMesResultHistoryList(uploadMesResultHistory);
    }

    /**
     * 新增上传MES返回结果历史记录
     * 
     * @param uploadMesResultHistory 上传MES返回结果历史记录
     * @return 结果
     */
    @Override
    public int insertUploadMesResultHistory(UploadMesResultHistory uploadMesResultHistory)
    {
        uploadMesResultHistory.setCreateTime(DateUtils.getNowDate());
        return uploadMesResultHistoryMapper.insertUploadMesResultHistory(uploadMesResultHistory);
    }

    /**
     * 修改上传MES返回结果历史记录
     * 
     * @param uploadMesResultHistory 上传MES返回结果历史记录
     * @return 结果
     */
    @Override
    public int updateUploadMesResultHistory(UploadMesResultHistory uploadMesResultHistory)
    {
        return uploadMesResultHistoryMapper.updateUploadMesResultHistory(uploadMesResultHistory);
    }

    /**
     * 批量删除上传MES返回结果历史记录
     * 
     * @param ids 需要删除的上传MES返回结果历史记录ID
     * @return 结果
     */
    @Override
    public int deleteUploadMesResultHistoryByIds(Long[] ids)
    {
        return uploadMesResultHistoryMapper.deleteUploadMesResultHistoryByIds(ids);
    }

    /**
     * 删除上传MES返回结果历史记录信息
     * 
     * @param id 上传MES返回结果历史记录ID
     * @return 结果
     */
    @Override
    public int deleteUploadMesResultHistoryById(Long id)
    {
        return uploadMesResultHistoryMapper.deleteUploadMesResultHistoryById(id);
    }
}
