package com.zehong.web.controller.equipment;

import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.ProcessCalibrationResultHistory;
import com.zehong.system.service.IProcessCalibrationResultHistoryService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 标定结果数据接收历史记录Controller
 * 
 * @author zehong
 * @date 2025-12-01
 */
@RestController
@RequestMapping("/calibrationResult/history")
public class ProcessCalibrationResultHistoryController extends BaseController
{
    @Resource
    private IProcessCalibrationResultHistoryService processCalibrationResultHistoryService;

    /**
     * 查询标定结果数据接收历史记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(ProcessCalibrationResultHistory processCalibrationResultHistory)
    {
        startPage();
        List<ProcessCalibrationResultHistory> list = processCalibrationResultHistoryService.selectProcessCalibrationResultHistoryList(processCalibrationResultHistory);
        return getDataTable(list);
    }

    /**
     * 导出标定结果数据接收历史记录列表
     */
    @GetMapping("/export")
    public AjaxResult export(ProcessCalibrationResultHistory processCalibrationResultHistory)
    {
        List<ProcessCalibrationResultHistory> list = processCalibrationResultHistoryService.selectProcessCalibrationResultHistoryList(processCalibrationResultHistory);
        ExcelUtil<ProcessCalibrationResultHistory> util = new ExcelUtil<ProcessCalibrationResultHistory>(ProcessCalibrationResultHistory.class);
        return util.exportExcel(list, "标定结果数据接收历史记录数据");
    }

    /**
     * 获取标定结果数据接收历史记录详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(processCalibrationResultHistoryService.selectProcessCalibrationResultHistoryById(id));
    }

    /**
     * 新增标定结果数据接收历史记录
     */
    @PostMapping
    public AjaxResult add(@RequestBody ProcessCalibrationResultHistory processCalibrationResultHistory)
    {
        return toAjax(processCalibrationResultHistoryService.insertProcessCalibrationResultHistory(processCalibrationResultHistory));
    }

    /**
     * 修改标定结果数据接收历史记录
     */
    @PutMapping
    public AjaxResult edit(@RequestBody ProcessCalibrationResultHistory processCalibrationResultHistory)
    {
        return toAjax(processCalibrationResultHistoryService.updateProcessCalibrationResultHistory(processCalibrationResultHistory));
    }

    /**
     * 删除标定结果数据接收历史记录
     */
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(processCalibrationResultHistoryService.deleteProcessCalibrationResultHistoryByIds(ids));
    }
}
