package com.zehong.web.controller.equipment;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.RobotArmCommand;
import com.zehong.system.service.IRobotArmCommandService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 机械臂指令Controller
 * 
 * @author zehong
 * @date 2025-08-04
 */
@RestController
@RequestMapping("/robotArm/command")
public class RobotArmCommandController extends BaseController
{
    @Autowired
    private IRobotArmCommandService robotArmCommandService;

    /**
     * 查询机械臂指令列表
     */
    @GetMapping("/list")
    public TableDataInfo list(RobotArmCommand robotArmCommand)
    {
        startPage();
        List<RobotArmCommand> list = robotArmCommandService.selectRobotArmCommandList(robotArmCommand);
        return getDataTable(list);
    }

    /**
     * 导出机械臂指令列表
     */
    @GetMapping("/export")
    public AjaxResult export(RobotArmCommand robotArmCommand)
    {
        List<RobotArmCommand> list = robotArmCommandService.selectRobotArmCommandList(robotArmCommand);
        ExcelUtil<RobotArmCommand> util = new ExcelUtil<RobotArmCommand>(RobotArmCommand.class);
        return util.exportExcel(list, "机械臂指令数据");
    }

    /**
     * 获取机械臂指令详细信息
     */
    @GetMapping(value = "/{robotArmCommandId}")
    public AjaxResult getInfo(@PathVariable("robotArmCommandId") Long robotArmCommandId)
    {
        return AjaxResult.success(robotArmCommandService.selectRobotArmCommandById(robotArmCommandId));
    }

    /**
     * 新增空白机械臂指令
     */
    @PostMapping("/insertBlankingRobotArmCommand")
    public AjaxResult insertBlankingRobotArmCommand(@RequestBody RobotArmCommand robotArmCommand) {
        return toAjax(robotArmCommandService.insertBlankingRobotArmCommand(robotArmCommand));
    }

    /**
     * 发送归位指令
     */
    @GetMapping("/sendHomeCommand")
    public AjaxResult sendHomeCommand() {
        robotArmCommandService.sendHomeCommand();
        return AjaxResult.success("发送成功");
    }

    /**
     * 停止当前指令
     */
    @GetMapping("/sendStopCommand")
    public AjaxResult sendStopCommand() {
        robotArmCommandService.sendStopCommand();
        return AjaxResult.success("发送成功");
    }

    /**
     * 新增机械臂指令
     */
    @PostMapping
    public AjaxResult add(@RequestBody RobotArmCommand robotArmCommand)
    {
        return toAjax(robotArmCommandService.insertRobotArmCommand(robotArmCommand));
    }

    @PostMapping("/powerOn")
    public AjaxResult powerOn(@RequestBody Map<String, Object> params) {
        Long commandId = Long.parseLong(params.get("commandId").toString());
        robotArmCommandService.powerOnCommand(commandId);
        return AjaxResult.success("上电操作成功");
    }

    @GetMapping("/sureCompletedCommand/{robotArmCommandId}")
    public AjaxResult sureCompletedCommand(@PathVariable("robotArmCommandId") Long robotArmCommandId) {
        return robotArmCommandService.sureCompletedCommand(robotArmCommandId);
    }




    /**
     * 修改机械臂指令
     */
    @PutMapping
    public AjaxResult edit(@RequestBody RobotArmCommand robotArmCommand)
    {
        return toAjax(robotArmCommandService.updateRobotArmCommand(robotArmCommand));
    }

    /**
     * 修改指令执行优先级
     */
    @GetMapping("/updateInstructionExecutionPriority/{priority}")
    public AjaxResult updateInstructionExecutionPriority(@PathVariable("priority")  String  priority) {
        return toAjax(robotArmCommandService.updateInstructionExecutionPriority(priority));
    }

    /**
     * 删除机械臂指令
     */
	@DeleteMapping("/{robotArmCommandIds}")
    public AjaxResult remove(@PathVariable Long[] robotArmCommandIds)
    {
        return toAjax(robotArmCommandService.deleteRobotArmCommandByIds(robotArmCommandIds));
    }
}
