import request from '@/utils/request'

// 查询传送带IP维护列表
export function listMaintain(query) {
  return request({
    url: '/conveyorBeltIp/maintain/list',
    method: 'get',
    params: query
  })
}

// 查询传送带IP维护详细
export function getMaintain(id) {
  return request({
    url: '/conveyorBeltIp/maintain/' + id,
    method: 'get'
  })
}

// 新增传送带IP维护
export function addMaintain(data) {
  return request({
    url: '/conveyorBeltIp/maintain',
    method: 'post',
    data: data
  })
}

// 修改传送带IP维护
export function updateMaintain(data) {
  return request({
    url: '/conveyorBeltIp/maintain',
    method: 'put',
    data: data
  })
}

// 删除传送带IP维护
export function delMaintain(id) {
  return request({
    url: '/conveyorBeltIp/maintain/' + id,
    method: 'delete'
  })
}

// 导出传送带IP维护
export function exportMaintain(query) {
  return request({
    url: '/conveyorBeltIp/maintain/export',
    method: 'get',
    params: query
  })
}
