package com.zehong.web.controller.equipment;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.PalletDeviceBinding;
import com.zehong.system.service.IPalletDeviceBindingService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 托盘绑定的设备列Controller
 * 
 * @author zehong
 * @date 2025-06-29
 */
@RestController
@RequestMapping("/palletDevice/binding")
public class PalletDeviceBindingController extends BaseController
{
    @Autowired
    private IPalletDeviceBindingService palletDeviceBindingService;

    /**
     * 查询托盘绑定的设备列列表
     */
    @GetMapping("/list")
    public TableDataInfo list(PalletDeviceBinding palletDeviceBinding)
    {
        startPage();
        List<PalletDeviceBinding> list = palletDeviceBindingService.selectPalletDeviceBindingList(palletDeviceBinding);
        return getDataTable(list);
    }

    /**
     * 获取所有托盘绑定的设备列列表
     */
    @GetMapping("/getAll")
    public AjaxResult getAll(PalletDeviceBinding palletDeviceBinding) {
        return AjaxResult.success(palletDeviceBindingService.selectPalletDeviceBindingList(palletDeviceBinding));
    }

    /**
     * 导出托盘绑定的设备列列表
     */
    @GetMapping("/export")
    public AjaxResult export(PalletDeviceBinding palletDeviceBinding)
    {
        List<PalletDeviceBinding> list = palletDeviceBindingService.selectPalletDeviceBindingList(palletDeviceBinding);
        ExcelUtil<PalletDeviceBinding> util = new ExcelUtil<PalletDeviceBinding>(PalletDeviceBinding.class);
        return util.exportExcel(list, "托盘绑定的设备列数据");
    }

    /**
     * 获取托盘绑定的设备列详细信息
     */
    @GetMapping(value = "/{palletDeviceBindingId}")
    public AjaxResult getInfo(@PathVariable("palletDeviceBindingId") Long palletDeviceBindingId)
    {
        return AjaxResult.success(palletDeviceBindingService.selectPalletDeviceBindingById(palletDeviceBindingId));
    }

    /**
     * 重置所有托盘绑定的设备列
     */
    @GetMapping("/resetAll/{trayId}")
    public AjaxResult resetAll(@PathVariable("trayId") Long trayId) {
        return AjaxResult.success(palletDeviceBindingService.resetAll(trayId));
    }

    /**
     * 新增托盘绑定的设备列
     */
    @PostMapping
    public AjaxResult add(@RequestBody PalletDeviceBinding palletDeviceBinding)
    {
        return toAjax(palletDeviceBindingService.insertPalletDeviceBinding(palletDeviceBinding));
    }

    /**
     * 批量新增托盘绑定的设备列
     * @param palletDeviceBindings p
     * @return l
     */
    @PostMapping ("/batchAdd")
    public AjaxResult batchAdd(@RequestBody List<PalletDeviceBinding> palletDeviceBindings){
        return toAjax(palletDeviceBindingService.batchInsertPalletDeviceBinding(palletDeviceBindings));
    }

    /**
     * 批量更新托盘绑定的设备列
     * @param palletDeviceBindings p
     * @return r
     */
    @PostMapping("/batchUpdateDeviceCode")
    public AjaxResult batchUpdateDeviceCode(@RequestBody List<PalletDeviceBinding> palletDeviceBindings) {
        return toAjax(palletDeviceBindingService.batchUpdateDeviceCode(palletDeviceBindings));
    }

    /**
     * 修改托盘绑定的设备列
     */
    @PutMapping
    public AjaxResult edit(@RequestBody PalletDeviceBinding palletDeviceBinding)
    {
        return toAjax(palletDeviceBindingService.updatePalletDeviceBinding(palletDeviceBinding));
    }

    /**
     * 删除托盘绑定的设备列
     */
	@DeleteMapping("/{palletDeviceBindingIds}")
    public AjaxResult remove(@PathVariable Long[] palletDeviceBindingIds)
    {
        return toAjax(palletDeviceBindingService.deletePalletDeviceBindingByIds(palletDeviceBindingIds));
    }
}
