import request from '@/utils/request'

// 查询托盘信息列表
export function listTray(query) {
  return request({
    url: '/tray/list',
    method: 'get',
    params: query
  })
}

// 查询托盘信息详细
export function getTray(fTrayId) {
  return request({
    url: '/tray/' + fTrayId,
    method: 'get'
  })
}

// 新增托盘信息
export function addTray(data) {
  return request({
    url: '/tray',
    method: 'post',
    data: data
  })
}

// 修改托盘信息
export function updateTray(data) {
  return request({
    url: '/tray',
    method: 'put',
    data: data
  })
}

// 删除托盘信息
export function delTray(fTrayId) {
  return request({
    url: '/tray/' + fTrayId,
    method: 'delete'
  })
}

// 导出托盘信息
export function exportTray(query) {
  return request({
    url: '/tray/export',
    method: 'get',
    params: query
  })
}
