import request from '@/utils/request'

// 查询老化层信息列表
export function listStorey(query) {
  return request({
    url: '/storey/list',
    method: 'get',
    params: query
  })
}

// 查询老化层信息详细
export function getStorey(fStoreyId) {
  return request({
    url: '/storey/' + fStoreyId,
    method: 'get'
  })
}

// 新增老化层信息
export function addStorey(data) {
  return request({
    url: '/storey',
    method: 'post',
    data: data
  })
}

// 修改老化层信息
export function updateStorey(data) {
  return request({
    url: '/storey',
    method: 'put',
    data: data
  })
}

// 删除老化层信息
export function delStorey(fStoreyId) {
  return request({
    url: '/storey/' + fStoreyId,
    method: 'delete'
  })
}

// 导出老化层信息
export function exportStorey(query) {
  return request({
    url: '/storey/export',
    method: 'get',
    params: query
  })
}
