import request from '@/utils/request'

// 查询生产设备信息列表
export function listEquipment(query) {
  return request({
    url: '/equipment/list',
    method: 'get',
    params: query
  })
}

// 查询生产设备信息详细
export function getEquipment(fEquipmentId) {
  return request({
    url: '/equipment/' + fEquipmentId,
    method: 'get'
  })
}

// 新增生产设备信息
export function addEquipment(data) {
  return request({
    url: '/equipment',
    method: 'post',
    data: data
  })
}

// 修改生产设备信息
export function updateEquipment(data) {
  return request({
    url: '/equipment',
    method: 'put',
    data: data
  })
}

// 删除生产设备信息
export function delEquipment(fEquipmentId) {
  return request({
    url: '/equipment/' + fEquipmentId,
    method: 'delete'
  })
}

// 导出生产设备信息
export function exportEquipment(query) {
  return request({
    url: '/equipment/export',
    method: 'get',
    params: query
  })
}
