package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TStoreyInfoMapper;
import com.zehong.system.domain.TStoreyInfo;
import com.zehong.system.service.ITStoreyInfoService;

/**
 * 老化层信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-05-28
 */
@Service
public class TStoreyInfoServiceImpl implements ITStoreyInfoService 
{
    @Autowired
    private TStoreyInfoMapper tStoreyInfoMapper;

    /**
     * 查询老化层信息
     * 
     * @param fStoreyId 老化层信息ID
     * @return 老化层信息
     */
    @Override
    public TStoreyInfo selectTStoreyInfoById(Long fStoreyId)
    {
        return tStoreyInfoMapper.selectTStoreyInfoById(fStoreyId);
    }

    /**
     * 查询老化层信息
     *
     * @param fStoreyCode 老化层信息Code
     * @return 老化层信息
     */
    @Override
    public TStoreyInfo selectTStoreyInfoByCode(String fStoreyCode)
    {
        return tStoreyInfoMapper.selectTStoreyInfoByCode(fStoreyCode);
    }

    /**
     * 查询老化层信息列表
     * 
     * @param tStoreyInfo 老化层信息
     * @return 老化层信息
     */
    @Override
    public List<TStoreyInfo> selectTStoreyInfoList(TStoreyInfo tStoreyInfo)
    {
        return tStoreyInfoMapper.selectTStoreyInfoList(tStoreyInfo);
    }

    /**
     * 新增老化层信息
     * 
     * @param tStoreyInfo 老化层信息
     * @return 结果
     */
    @Override
    public int insertTStoreyInfo(TStoreyInfo tStoreyInfo)
    {
        return tStoreyInfoMapper.insertTStoreyInfo(tStoreyInfo);
    }

    /**
     * 修改老化层信息
     * 
     * @param tStoreyInfo 老化层信息
     * @return 结果
     */
    @Override
    public int updateTStoreyInfo(TStoreyInfo tStoreyInfo)
    {
        return tStoreyInfoMapper.updateTStoreyInfo(tStoreyInfo);
    }

    /**
     * 批量删除老化层信息
     * 
     * @param fStoreyIds 需要删除的老化层信息ID
     * @return 结果
     */
    @Override
    public int deleteTStoreyInfoByIds(Long[] fStoreyIds)
    {
        return tStoreyInfoMapper.deleteTStoreyInfoByIds(fStoreyIds);
    }

    /**
     * 删除老化层信息信息
     * 
     * @param fStoreyId 老化层信息ID
     * @return 结果
     */
    @Override
    public int deleteTStoreyInfoById(Long fStoreyId)
    {
        return tStoreyInfoMapper.deleteTStoreyInfoById(fStoreyId);
    }
}
