package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TStoreyInfo;

/**
 * 老化层信息Service接口
 * 
 * @author zehong
 * @date 2025-05-28
 */
public interface ITStoreyInfoService 
{
    /**
     * 查询老化层信息
     * 
     * @param fStoreyId 老化层信息ID
     * @return 老化层信息
     */
    public TStoreyInfo selectTStoreyInfoById(Long fStoreyId);

    /**
     * 查询老化层信息
     *
     * @param fStoreyCode 老化层信息Code
     * @return 老化层信息
     */
    public TStoreyInfo selectTStoreyInfoByCode(String fStoreyCode);

    /**
     * 查询老化层信息列表
     * 
     * @param tStoreyInfo 老化层信息
     * @return 老化层信息集合
     */
    public List<TStoreyInfo> selectTStoreyInfoList(TStoreyInfo tStoreyInfo);

    /**
     * 新增老化层信息
     * 
     * @param tStoreyInfo 老化层信息
     * @return 结果
     */
    public int insertTStoreyInfo(TStoreyInfo tStoreyInfo);

    /**
     * 修改老化层信息
     * 
     * @param tStoreyInfo 老化层信息
     * @return 结果
     */
    public int updateTStoreyInfo(TStoreyInfo tStoreyInfo);

    /**
     * 批量删除老化层信息
     * 
     * @param fStoreyIds 需要删除的老化层信息ID
     * @return 结果
     */
    public int deleteTStoreyInfoByIds(Long[] fStoreyIds);

    /**
     * 删除老化层信息信息
     * 
     * @param fStoreyId 老化层信息ID
     * @return 结果
     */
    public int deleteTStoreyInfoById(Long fStoreyId);
}
