package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 老化层信息对象 t_storey_info
 * 
 * @author zehong
 * @date 2025-05-29
 */
public class TStoreyInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 层ID */
    private Long fStoreyId;

    /** 所属老化柜ID */
    @Excel(name = "所属老化柜ID")
    private Long fEquipmentId;

    /** 层编号 */
    @Excel(name = "层编号")
    private String fStoreyCode;

    /** IP地址 */
    @Excel(name = "IP地址")
    private String fIp;

    /** 端口号 */
    @Excel(name = "端口号")
    private Integer fPort;

    /** 状态：0空闲，1运行，2故障，3断电*/
    @Excel(name = "状态：0空闲，1运行，2故障，3断电")
    private String fStatus;

    /** 老化开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date fAgingStartTime;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fUpdateTime;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fCreateTime;

    /** 报警时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "报警时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fAlarmTime;

    public void setfStoreyId(Long fStoreyId) 
    {
        this.fStoreyId = fStoreyId;
    }

    public Long getfStoreyId() 
    {
        return fStoreyId;
    }
    public void setfEquipmentId(Long fEquipmentId) 
    {
        this.fEquipmentId = fEquipmentId;
    }

    public Long getfEquipmentId() 
    {
        return fEquipmentId;
    }
    public void setfStoreyCode(String fStoreyCode) 
    {
        this.fStoreyCode = fStoreyCode;
    }

    public String getfStoreyCode() 
    {
        return fStoreyCode;
    }

    public void setfIp(String fIp) 
    {
        this.fIp = fIp;
    }

    public String getfIp() 
    {
        return fIp;
    }
    public void setfStatus(String fStatus) 
    {
        this.fStatus = fStatus;
    }

    public String getfStatus() 
    {
        return fStatus;
    }
    public void setfPort(Integer fPort)
    {
        this.fPort = fPort;
    }

    public Integer getfPort()
    {
        return fPort;
    }

    public Date getfAgingStartTime() {
        return fAgingStartTime;
    }

    public void setfAgingStartTime(Date fAgingStartTime) {
        this.fAgingStartTime = fAgingStartTime;
    }

    public void setfUpdateTime(Date fUpdateTime)
    {
        this.fUpdateTime = fUpdateTime;
    }

    public Date getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfCreateTime(Date fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public Date getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfAlarmTime(Date fAlarmTime) 
    {
        this.fAlarmTime = fAlarmTime;
    }

    public Date getfAlarmTime() 
    {
        return fAlarmTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fStoreyId", getfStoreyId())
            .append("fEquipmentId", getfEquipmentId())
            .append("fStoreyCode", getfStoreyCode())
            .append("fIp", getfIp())
            .append("fStatus", getfStatus())
            .append("fPort", getfPort())
            .append("fAgingStartTime", getfUpdateTime())
            .append("fUpdateTime", getfUpdateTime())
            .append("fCreateTime", getfCreateTime())
            .append("fAlarmTime", getfAlarmTime())
            .toString();
    }
}
