package com.zehong.web.controller.equipment;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEquipmentInfo;
import com.zehong.system.service.ITEquipmentInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 生产设备信息Controller
 * 
 * @author zehong
 * @date 2025-05-28
 */
@RestController
@RequestMapping("/equipment")
public class TEquipmentInfoController extends BaseController
{
    @Autowired
    private ITEquipmentInfoService tEquipmentInfoService;

    /**
     * 查询生产设备信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEquipmentInfo tEquipmentInfo)
    {
        startPage();
        List<TEquipmentInfo> list = tEquipmentInfoService.selectTEquipmentInfoList(tEquipmentInfo);
        return getDataTable(list);
    }

    /**
     * 导出生产设备信息列表
     */
    @Log(title = "生产设备信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEquipmentInfo tEquipmentInfo)
    {
        List<TEquipmentInfo> list = tEquipmentInfoService.selectTEquipmentInfoList(tEquipmentInfo);
        ExcelUtil<TEquipmentInfo> util = new ExcelUtil<TEquipmentInfo>(TEquipmentInfo.class);
        return util.exportExcel(list, "生产设备信息数据");
    }

    /**
     * 获取生产设备信息详细信息
     */
    @GetMapping(value = "/{fEquipmentId}")
    public AjaxResult getInfo(@PathVariable("fEquipmentId") Long fEquipmentId)
    {
        return AjaxResult.success(tEquipmentInfoService.selectTEquipmentInfoById(fEquipmentId));
    }

    /**
     * 新增生产设备信息
     */
    @Log(title = "生产设备信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEquipmentInfo tEquipmentInfo)
    {
        return toAjax(tEquipmentInfoService.insertTEquipmentInfo(tEquipmentInfo));
    }

    /**
     * 修改生产设备信息
     */
    @Log(title = "生产设备信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEquipmentInfo tEquipmentInfo)
    {
        return toAjax(tEquipmentInfoService.updateTEquipmentInfo(tEquipmentInfo));
    }

    /**
     * 删除生产设备信息
     */
    @Log(title = "生产设备信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fEquipmentIds}")
    public AjaxResult remove(@PathVariable Long[] fEquipmentIds)
    {
        return toAjax(tEquipmentInfoService.deleteTEquipmentInfoByIds(fEquipmentIds));
    }
}
