package com.zehong.system.mapper;

import java.util.List;

import com.zehong.system.domain.PalletDeviceBinding;
import com.zehong.system.domain.PalletDeviceUploadHistory;

/**
 * 未上传成功的历史数据列Mapper接口
 *
 * @author zehong
 * @date 2025-11-24
 */
public interface PalletDeviceUploadHistoryMapper
{
    /**
     * 查询未上传成功的历史数据列
     *
     * @param id 未上传成功的历史数据列ID
     * @return 未上传成功的历史数据列
     */
    public PalletDeviceUploadHistory selectPalletDeviceUploadHistoryById(Long id);

    /**
     * 查询未上传成功的历史数据列列表
     *
     * @param palletDeviceUploadHistory 未上传成功的历史数据列
     * @return 未上传成功的历史数据列集合
     */
    public List<PalletDeviceUploadHistory> selectPalletDeviceUploadHistoryList(PalletDeviceUploadHistory palletDeviceUploadHistory);

    /**
     * 新增未上传成功的历史数据列
     *
     * @param palletDeviceUploadHistory 未上传成功的历史数据列
     * @return 结果
     */
    public int insertPalletDeviceUploadHistory(PalletDeviceUploadHistory palletDeviceUploadHistory);

    public int batchInsert(List<PalletDeviceUploadHistory> list);

    public int batchInsertRealTimeData(List<PalletDeviceBinding>  list);

    /**
     * 修改未上传成功的历史数据列
     *
     * @param palletDeviceUploadHistory 未上传成功的历史数据列
     * @return 结果
     */
    public int updatePalletDeviceUploadHistory(PalletDeviceUploadHistory palletDeviceUploadHistory);

    /**
     * 删除未上传成功的历史数据列
     *
     * @param id 未上传成功的历史数据列ID
     * @return 结果
     */
    public int deletePalletDeviceUploadHistoryById(Long id);

    /**
     * 批量删除未上传成功的历史数据列
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deletePalletDeviceUploadHistoryByIds(Long[] ids);
}
