package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 未上传成功的历史数据列对象 t_pallet_device_upload_history
 *
 * @author zehong
 * @date 2025-11-24
 */
public class PalletDeviceUploadHistory extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 托盘id */
    private Long id;

    /** 托盘id */
    private Long trayId;
    /** 绑定层编号 */
    @Excel(name = "绑定层编号")
    private String storeyCode;

    /** 托盘编号 */
    @Excel(name = "托盘编号")
    private String trayCode;

    /** 绑定的设备编号 */
    @Excel(name = "设备编号")
    private String motherboardCode;

    /** 行 */
    @Excel(name = "行")
    private Integer row;

    /** 列 */
    @Excel(name = "列")
    private Integer col;

    /** 第几个 */
    @Excel(name = "第几个")
    private Integer index;

    /** 编号 */
    @Excel(name = "编号")
    private Integer number;

    /** 绑定时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "绑定时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date bindingTime;

    /** 解绑时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date unbindingTime;

    /** 0-预热；1-正常;3-传感器故障;4-报警；5-通讯故障 ；-9999-通讯异常*/
    @Excel(name = "状态")
    private String deviceStatus;

    /** 设置-年 */
    @Excel(name = "设置-年")
    private String recordYear;

    /** 设置-月 */
    @Excel(name = "设置-月")
    private String recordMonth;

    /** 设置-日 */
    @Excel(name = "设置-日")
    private String recordDate;

    /** 设置-时 */
    @Excel(name = "设置-时")
    private String recordHour;

    /** 设置-分 */
    @Excel(name = "设置-分")
    private String recordMinute;

    /** 写入时间状态;0-失败;1-成功 */
    @Excel(name = "写入时间状态;0-失败;1-成功")
    private String writeTimeStatus;

    /** 调零AD */
    @Excel(name = "调零AD")
    private String adjustmentZeroAd;

    /** 合格；不合格 */
    @Excel(name = "调零状态")
    private String zeroStatus;

    /** 标定AD */
    @Excel(name = "标定AD")
    private String calibrationAd;

    /** 合格；不合格 */
    @Excel(name = "标定状态0-不合格;1-合格")
    private String calibrationAdStatus;

    /** 浓度值 */
    @Excel(name = "浓度值")
    private String concentration;

    /** 写入时间状态;0-失败;1-成功 */
    @Excel(name = "写入时间状态;0-失败;1-成功")
    private String runTimeStatus;

    /** 实时AD值 */
    @Excel(name = "实时AD值")
    private Integer realTimeAd;

    /** 实时AD状态;0-异常;1-正常 */
    @Excel(name = "实时AD状态;0-异常;1-正常 ")
    private String realTimeStatus;

    /**
     * 传感器校准浓度
     */
    @Excel(name = "校准浓度")
    private BigDecimal calibrationConcentration;

    /**
     * 传感器校准状态 4-正常，其他都是异常
     * 0-预热；1-正常；3-传感器故障；4-报警；5-通讯故障； 只有是4的时候显示正常，其他的都是异常
     */
    @Excel(name = "校准浓度状态;0-预热；1-正常；3-传感器故障；4-报警；5-通讯故障； 只有是4的时候显示正常")
    private String calibrationConcentrationStatus;

    /**
     * 写自检状态 空 是没写 0-失败;1-成功
     */
    @Excel(name = "写自检状态;0-失败;1-成功")
    private Integer writeSelfCheckStatus;

    /**
     * 继电器状态 0：初始 1：动作
     */
    @Excel(name = "继电器状态;0:初始 1:动作")
    private Integer relayStatus;

    /**
     * 脉冲状态 0：初始 1：动作
     */
    @Excel(name = "脉冲状态;0:初始 1:动作")
    private Integer pulseStatus;

    /**
     * 模块状态 0：异常 1：正常
     */
    @Excel(name = "模块状态;0:异常 1:正常")
    private Integer moduleStatus;

    /**
     * SIM卡状态 0：异常 1：正常
     */
    @Excel(name = "SIM卡状态;0:异常 1:正常")
    private Integer simCardStatus;

    /**
     * 网络状态 0：异常 1：正常
     */
    @Excel(name = "网络状态;0:异常 1:正常")
    private Integer networkStatus;

    /** 产品标准检验编号 */
    @Excel(name = "标检单号")
    private String productStandardInspectionNumber;

    /** 标检结果 */
    private String standardInspectResult;
    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setTrayId(Long trayId)
    {
        this.trayId = trayId;
    }

    public Long getTrayId()
    {
        return trayId;
    }

    public String getMotherboardCode() {
        return motherboardCode;
    }

    public void setMotherboardCode(String motherboardCode) {
        this.motherboardCode = motherboardCode;
    }
    public void setRow(Integer row)
    {
        this.row = row;
    }

    public Integer getRow()
    {
        return row;
    }
    public void setCol(Integer col)
    {
        this.col = col;
    }

    public Integer getCol()
    {
        return col;
    }
    public void setIndex(Integer index)
    {
        this.index = index;
    }

    public Integer getIndex()
    {
        return index;
    }
    public void setNumber(Integer number)
    {
        this.number = number;
    }

    public Integer getNumber()
    {
        return number;
    }
    public void setBindingTime(Date bindingTime)
    {
        this.bindingTime = bindingTime;
    }

    public Date getBindingTime()
    {
        return bindingTime;
    }
    public void setUnbindingTime(Date unbindingTime)
    {
        this.unbindingTime = unbindingTime;
    }

    public Date getUnbindingTime()
    {
        return unbindingTime;
    }

    public String getDeviceStatus() {
        return deviceStatus;
    }

    public void setDeviceStatus(String deviceStatus) {
        this.deviceStatus = deviceStatus;
    }

    public void setRecordYear(String recordYear)
    {
        this.recordYear = recordYear;
    }

    public String getRecordYear()
    {
        return recordYear;
    }
    public void setRecordMonth(String recordMonth)
    {
        this.recordMonth = recordMonth;
    }

    public String getRecordMonth()
    {
        return recordMonth;
    }
    public void setRecordDate(String recordDate)
    {
        this.recordDate = recordDate;
    }

    public String getRecordDate()
    {
        return recordDate;
    }
    public void setRecordHour(String recordHour)
    {
        this.recordHour = recordHour;
    }

    public String getRecordHour()
    {
        return recordHour;
    }
    public void setRecordMinute(String recordMinute)
    {
        this.recordMinute = recordMinute;
    }

    public String getRecordMinute()
    {
        return recordMinute;
    }
    public void setWriteTimeStatus(String writeTimeStatus)
    {
        this.writeTimeStatus = writeTimeStatus;
    }

    public String getWriteTimeStatus()
    {
        return writeTimeStatus;
    }
    public void setAdjustmentZeroAd(String adjustmentZeroAd)
    {
        this.adjustmentZeroAd = adjustmentZeroAd;
    }

    public String getAdjustmentZeroAd()
    {
        return adjustmentZeroAd;
    }
    public void setZeroStatus(String zeroStatus)
    {
        this.zeroStatus = zeroStatus;
    }

    public String getZeroStatus()
    {
        return zeroStatus;
    }
    public void setCalibrationAd(String calibrationAd)
    {
        this.calibrationAd = calibrationAd;
    }

    public String getCalibrationAd()
    {
        return calibrationAd;
    }

    public String getCalibrationAdStatus() {
        return calibrationAdStatus;
    }

    public void setCalibrationAdStatus(String calibrationAdStatus) {
        this.calibrationAdStatus = calibrationAdStatus;
    }

    public void setConcentration(String concentration)
    {
        this.concentration = concentration;
    }

    public String getConcentration()
    {
        return concentration;
    }
    public void setRunTimeStatus(String runTimeStatus)
    {
        this.runTimeStatus = runTimeStatus;
    }

    public String getRunTimeStatus()
    {
        return runTimeStatus;
    }
    public void setRealTimeAd(Integer realTimeAd)
    {
        this.realTimeAd = realTimeAd;
    }

    public Integer getRealTimeAd()
    {
        return realTimeAd;
    }

    public String getRealTimeStatus() {
        return realTimeStatus;
    }

    public void setRealTimeStatus(String realTimeStatus) {
        this.realTimeStatus = realTimeStatus;
    }

    public String getTrayCode() {
        return trayCode;
    }

    public void setTrayCode(String trayCode) {
        this.trayCode = trayCode;
    }

    public BigDecimal getCalibrationConcentration() {
        return calibrationConcentration;
    }

    public void setCalibrationConcentration(BigDecimal calibrationConcentration) {
        this.calibrationConcentration = calibrationConcentration;
    }

    public String getCalibrationConcentrationStatus() {
        return calibrationConcentrationStatus;
    }

    public void setCalibrationConcentrationStatus(String calibrationConcentrationStatus) {
        this.calibrationConcentrationStatus = calibrationConcentrationStatus;
    }

    public Integer getWriteSelfCheckStatus() {
        return writeSelfCheckStatus;
    }

    public void setWriteSelfCheckStatus(Integer writeSelfCheckStatus) {
        this.writeSelfCheckStatus = writeSelfCheckStatus;
    }

    public Integer getRelayStatus() {
        return relayStatus;
    }

    public void setRelayStatus(Integer relayStatus) {
        this.relayStatus = relayStatus;
    }

    public Integer getPulseStatus() {
        return pulseStatus;
    }

    public void setPulseStatus(Integer pulseStatus) {
        this.pulseStatus = pulseStatus;
    }

    public Integer getModuleStatus() {
        return moduleStatus;
    }

    public void setModuleStatus(Integer moduleStatus) {
        this.moduleStatus = moduleStatus;
    }

    public Integer getSimCardStatus() {
        return simCardStatus;
    }

    public void setSimCardStatus(Integer simCardStatus) {
        this.simCardStatus = simCardStatus;
    }

    public Integer getNetworkStatus() {
        return networkStatus;
    }

    public void setNetworkStatus(Integer networkStatus) {
        this.networkStatus = networkStatus;
    }

    public String getStoreyCode() {
        return storeyCode;
    }

    public void setStoreyCode(String storeyCode) {
        this.storeyCode = storeyCode;
    }

    public String getProductStandardInspectionNumber() {
        return productStandardInspectionNumber;
    }

    public void setProductStandardInspectionNumber(String productStandardInspectionNumber) {
        this.productStandardInspectionNumber = productStandardInspectionNumber;
    }

    public String getStandardInspectResult() {
        return standardInspectResult;
    }

    public void setStandardInspectResult(String standardInspectResult) {
        this.standardInspectResult = standardInspectResult;
    }

    @Override
    public String toString() {
        return "PalletDeviceUploadHistory{" +
                "id=" + id +
                ", trayId=" + trayId +
                ", storeyCode=" + storeyCode +
                ", trayCode='" + trayCode + '\'' +
                ", motherboardCode='" + motherboardCode + '\'' +
                ", row=" + row +
                ", col=" + col +
                ", index=" + index +
                ", number=" + number +
                ", bindingTime=" + bindingTime +
                ", unbindingTime=" + unbindingTime +
                ", deviceStatus='" + deviceStatus + '\'' +
                ", recordYear='" + recordYear + '\'' +
                ", recordMonth='" + recordMonth + '\'' +
                ", recordDate='" + recordDate + '\'' +
                ", recordHour='" + recordHour + '\'' +
                ", recordMinute='" + recordMinute + '\'' +
                ", writeTimeStatus='" + writeTimeStatus + '\'' +
                ", adjustmentZeroAd='" + adjustmentZeroAd + '\'' +
                ", zeroStatus='" + zeroStatus + '\'' +
                ", calibrationAd='" + calibrationAd + '\'' +
                ", calibrationAdStatus='" + calibrationAdStatus + '\'' +
                ", concentration='" + concentration + '\'' +
                ", runTimeStatus='" + runTimeStatus + '\'' +
                ", realTimeAd=" + realTimeAd +
                ", realTimeStatus='" + realTimeStatus + '\'' +
                ", calibrationConcentration=" + calibrationConcentration +
                ", calibrationConcentrationStatus='" + calibrationConcentrationStatus + '\'' +
                ", writeSelfCheckStatus=" + writeSelfCheckStatus +
                ", relayStatus=" + relayStatus +
                ", pulseStatus=" + pulseStatus +
                ", moduleStatus=" + moduleStatus +
                ", simCardStatus=" + simCardStatus +
                ", networkStatus=" + networkStatus +
                ", productStandardInspectionNumber='" + productStandardInspectionNumber +
                ", standardInspectResult='" + standardInspectResult +
                '}';
    }
}
