package com.zehong.system.domain;

import java.util.Date;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 生产设备信息对象 t_equipment_info
 * 
 * @author zehong
 * @date 2025-05-28
 */
public class TEquipmentInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 生产设备id */
    private Long fEquipmentId;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String fEquipmentCode;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String fEquipmentName;

    /** 设备类型：1.老化柜、2.标定车、3.机械臂、4.镭雕机、5.AOI检测设备 */
    @Excel(name = "设备类型：1.老化柜、2.标定车、3.机械臂、4.镭雕机、5.AOI检测设备")
    private String fEquipmentType;

    /** 厂家 */
    @Excel(name = "厂家")
    private String fEquipmentFactory;

    /** 所属部门 */
    @Excel(name = "所属部门")
    private String fBeyongDepartment;

    /** IP地址 */
    @Excel(name = "IP地址")
    private String fIp;

    /** 端口号 */
    @Excel(name = "端口号")
    private Integer fPort;

    /** 安装位置 */
    @Excel(name = "安装位置")
    private String fInstallLocation;

    /** 是否巡查点：1.是，2.否 */
    @Excel(name = "是否巡查点：1.是，2.否")
    private String fIsInspect;

    /** 负责人 */
    @Excel(name = "负责人")
    private String fResponsiblePerson;

    /** 负责人电话 */
    @Excel(name = "负责人电话")
    private String fResponsiblePersonMobile;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fCreateTime;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fUpdateTime;

    /** 状态：0空闲，1运行，2故障 */
    @Excel(name = "状态：0空闲，1运行，2故障")
    private String fStatus;

    /**
     * 寄存器值
     */
    private Map<Integer,Object> registerValues;

    /**
     * 故障原因
     */
    private String errorReason;

    /** 报警时间 */
    @Excel(name = "报警时间")
    private String fAlarmTime;


    /** 断电层IP地址 */
    private String fPowerOutageIp;

    /** 断电层端口号 */
    private Integer fPowerOutagePort;

    public void setfEquipmentId(Long fEquipmentId) 
    {
        this.fEquipmentId = fEquipmentId;
    }

    public Long getfEquipmentId() 
    {
        return fEquipmentId;
    }
    public void setfEquipmentCode(String fEquipmentCode) 
    {
        this.fEquipmentCode = fEquipmentCode;
    }

    public String getfEquipmentCode() 
    {
        return fEquipmentCode;
    }
    public void setfEquipmentName(String fEquipmentName) 
    {
        this.fEquipmentName = fEquipmentName;
    }

    public String getfEquipmentName() 
    {
        return fEquipmentName;
    }
    public void setfEquipmentType(String fEquipmentType) 
    {
        this.fEquipmentType = fEquipmentType;
    }

    public String getfEquipmentType() 
    {
        return fEquipmentType;
    }
    public void setfEquipmentFactory(String fEquipmentFactory) 
    {
        this.fEquipmentFactory = fEquipmentFactory;
    }

    public String getfEquipmentFactory() 
    {
        return fEquipmentFactory;
    }
    public void setfBeyongDepartment(String fBeyongDepartment) 
    {
        this.fBeyongDepartment = fBeyongDepartment;
    }

    public String getfBeyongDepartment() 
    {
        return fBeyongDepartment;
    }
    public void setfIp(String fIp) 
    {
        this.fIp = fIp;
    }

    public String getfIp() 
    {
        return fIp;
    }
    public void setfPort(Integer fPort)
    {
        this.fPort = fPort;
    }

    public Integer getfPort()
    {
        return fPort;
    }
    public void setfInstallLocation(String fInstallLocation) 
    {
        this.fInstallLocation = fInstallLocation;
    }

    public String getfInstallLocation() 
    {
        return fInstallLocation;
    }
    public void setfIsInspect(String fIsInspect) 
    {
        this.fIsInspect = fIsInspect;
    }

    public String getfIsInspect() 
    {
        return fIsInspect;
    }
    public void setfResponsiblePerson(String fResponsiblePerson) 
    {
        this.fResponsiblePerson = fResponsiblePerson;
    }

    public String getfResponsiblePerson() 
    {
        return fResponsiblePerson;
    }
    public void setfResponsiblePersonMobile(String fResponsiblePersonMobile) 
    {
        this.fResponsiblePersonMobile = fResponsiblePersonMobile;
    }

    public String getfResponsiblePersonMobile() 
    {
        return fResponsiblePersonMobile;
    }
    public void setfCreateTime(Date fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public Date getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfUpdateTime(Date fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public Date getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfStatus(String fStatus) 
    {
        this.fStatus = fStatus;
    }

    public String getfStatus() 
    {
        return fStatus;
    }
    public void setfAlarmTime(String fAlarmTime) 
    {
        this.fAlarmTime = fAlarmTime;
    }

    public String getfAlarmTime() 
    {
        return fAlarmTime;
    }

    public String getfPowerOutageIp() {
        return fPowerOutageIp;
    }

    public void setfPowerOutageIp(String fPowerOutageIp) {
        this.fPowerOutageIp = fPowerOutageIp;
    }

    public Integer getfPowerOutagePort() {
        return fPowerOutagePort;
    }

    public void setfPowerOutagePort(Integer fPowerOutagePort) {
        this.fPowerOutagePort = fPowerOutagePort;
    }

    public String getErrorReason() {
        return errorReason;
    }

    public void setErrorReason(String errorReason) {
        this.errorReason = errorReason;
    }

    public Map<Integer, Object> getRegisterValues() {
        return registerValues;
    }

    public void setRegisterValues(Map<Integer, Object> registerValues) {
        this.registerValues = registerValues;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fEquipmentId", getfEquipmentId())
            .append("fEquipmentCode", getfEquipmentCode())
            .append("fEquipmentName", getfEquipmentName())
            .append("fEquipmentType", getfEquipmentType())
            .append("fEquipmentFactory", getfEquipmentFactory())
            .append("fBeyongDepartment", getfBeyongDepartment())
            .append("fIp", getfIp())
            .append("fPort", getfPort())
            .append("fInstallLocation", getfInstallLocation())
            .append("fIsInspect", getfIsInspect())
            .append("fResponsiblePerson", getfResponsiblePerson())
            .append("fResponsiblePersonMobile", getfResponsiblePersonMobile())
            .append("fCreateTime", getfCreateTime())
            .append("fUpdateTime", getfUpdateTime())
            .append("fStatus", getfStatus())
            .append("fAlarmTime", getfAlarmTime())
            .toString();
    }
}
