import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listSign(query) {
  return request({
    url: '/workPermit/sign/list',
    method: 'get',
    params: query
  })
}

export function batchUpdateSignWorkPermit(data) {
  return request({
    url: '/workPermit/sign/batchUpdateSignWorkPermit',
    method: 'post',
    data: data
  })
}

// 查询【请填写功能名称】详细
export function getSign(signId) {
  return request({
    url: '/workPermit/sign/' + signId,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addSign(data) {
  return request({
    url: '/workPermit/sign',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateSign(data) {
  return request({
    url: '/workPermit/sign',
    method: 'put',
    data: data
  })
}

// 删除【请填写功能名称】
export function delSign(signId) {
  return request({
    url: '/workPermit/sign/' + signId,
    method: 'delete'
  })
}

// 导出【请填写功能名称】
export function exportSign(query) {
  return request({
    url: '/workPermit/sign/export',
    method: 'get',
    params: query
  })
}
