import request from '@/utils/request'

// 查询作业许可证列表
export function listPermit(query) {
  return request({
    url: '/work/permit/list',
    method: 'get',
    params: query
  })
}

export function selectTWorkPermitListByLoginUser(query) {
  return request({
    url: '/work/permit/selectTWorkPermitListByLoginUser',
    method: 'get',
    params: query
  })
}

// 查询作业许可证详细
export function getPermit(workPermitId) {
  return request({
    url: '/work/permit/' + workPermitId,
    method: 'get'
  })
}

// 新增作业许可证
export function addPermit(data) {
  return request({
    url: '/work/permit',
    method: 'post',
    data: data
  })
}

// 修改作业许可证
export function updatePermit(data) {
  return request({
    url: '/work/permit',
    method: 'put',
    data: data
  })
}

export function judgeSignUpdateTWorkPermit(query) {
  return request({
    url: '/work/permit/judgeSignUpdateTWorkPermit',
    method: 'get',
    params: query
  })
}

// 删除作业许可证
export function delPermit(workPermitId) {
  return request({
    url: '/work/permit/' + workPermitId,
    method: 'delete'
  })
}


// 导出作业许可证
export function exportPermit(query) {
  return request({
    url: '/work/permit/export',
    method: 'get',
    params: query
  })
}
