import request from '@/utils/request'

// 查询setting列表
export function listSetting(query) {
  return request({
    url: '/system/inspection/list',
    method: 'get',
    params: query
  })
}

// 查询setting详细
export function getSetting(nfcId) {
  return request({
    url: '/system/inspection/' + nfcId,
    method: 'get'
  })
}

// 新增setting
export function addSetting(data) {
  return request({
    url: '/system/inspection',
    method: 'post',
    data: data
  })
}

// 修改setting
export function updateSetting(data) {
  return request({
    url: '/system/inspection',
    method: 'put',
    data: data
  })
}

// 删除setting
export function delSetting(nfcId) {
  return request({
    url: '/system/inspection/' + nfcId,
    method: 'delete'
  })
}

// 导出setting
export function exportSetting(query) {
  return request({
    url: '/system/inspection/export',
    method: 'get',
    params: query
  })
}
