import request from '@/utils/request'

// 查询巡检点列表
export function listPosition(query) {
  return request({
    url: '/system/position/list',
    method: 'get',
    params: query
  })
}

// 查询巡检点详细
export function getPosition(patrolId) {
  return request({
    url: '/system/position/' + patrolId,
    method: 'get'
  })
}

// 新增巡检点
export function addPosition(data) {
  return request({
    url: '/system/position',
    method: 'post',
    data: data
  })
}

// 修改巡检点
export function updatePosition(data) {
  return request({
    url: '/system/position',
    method: 'put',
    data: data
  })
}

// 删除巡检点
export function delPosition(patrolId) {
  return request({
    url: '/system/position/' + patrolId,
    method: 'delete'
  })
}

// 导出巡检点
export function exportPosition(query) {
  return request({
    url: '/system/position/export',
    method: 'get',
    params: query
  })
}