import request from '@/utils/request'

// 查询巡检计划列表
export function listReservePlan(query) {
  return request({
    url: '/system/reservePlan/list',
    method: 'get',
    params: query
  })
}

// 查询巡检计划详细
export function getReservePlan(planId) {
  return request({
    url: '/system/reservePlan/' + planId,
    method: 'get'
  })
}

// 新增巡检计划
export function addReservePlan(data) {
  return request({
    url: '/system/reservePlan',
    method: 'post',
    data: data
  })
}

// 修改巡检计划
export function updateReservePlan(data) {
  return request({
    url: '/system/reservePlan',
    method: 'put',
    data: data
  })
}

// 删除巡检计划
export function delReservePlan(planId) {
  return request({
    url: '/system/reservePlan/' + planId,
    method: 'delete'
  })
}

// 导出巡检计划
export function exportReservePlan(query) {
  return request({
    url: '/system/reservePlan/export',
    method: 'get',
    params: query
  })
}
