import request from '@/utils/request'

// 查询隐患排查库列表
export function listLibrary(query) {
  return request({
    url: '/system/library/list',
    method: 'get',
    params: query
  })
}

// 查询隐患排查库详细
export function getLibrary(libraryId) {
  return request({
    url: '/system/library/' + libraryId,
    method: 'get'
  })
}

// 新增隐患排查库
export function addLibrary(data) {
  return request({
    url: '/system/library',
    method: 'post',
    data: data
  })
}

// 修改隐患排查库
export function updateLibrary(data) {
  return request({
    url: '/system/library',
    method: 'put',
    data: data
  })
}

// 删除隐患排查库
export function delLibrary(libraryId) {
  return request({
    url: '/system/library/' + libraryId,
    method: 'delete'
  })
}

// 导出隐患排查库
export function exportLibrary(query) {
  return request({
    url: '/system/library/export',
    method: 'get',
    params: query
  })
}