import request from '@/utils/request'

// 查询投入台账列表
export function listInvestment(query) {
  return request({
    url: '/safetyManagement/investment/list',
    method: 'get',
    params: query
  })
}

// 查询投入台账详细
export function getInvestment(id) {
  return request({
    url: '/safetyManagement/investment/' + id,
    method: 'get'
  })
}

// 新增投入台账
export function addInvestment(data) {
  return request({
    url: '/safetyManagement/investment',
    method: 'post',
    data: data
  })
}

// 修改投入台账
export function updateInvestment(data) {
  return request({
    url: '/safetyManagement/investment',
    method: 'put',
    data: data
  })
}

// 删除投入台账
export function delInvestment(id) {
  return request({
    url: '/safetyManagement/investment/' + id,
    method: 'delete'
  })
}

// 导出投入台账
export function exportInvestment(query) {
  return request({
    url: '/safetyManagement/investment/export',
    method: 'get',
    params: query
  })
}