import request from '@/utils/request'

// 查询企业制度管理列表
export function listEnterpriseSystem(query) {
  return request({
    url: '/safetyManagement/enterpriseSystem/list',
    method: 'get',
    params: query
  })
}

// 查询企业制度管理详细
export function getEnterpriseSystem(systemId) {
  return request({
    url: '/safetyManagement/enterpriseSystem/' + systemId,
    method: 'get'
  })
}

// 新增企业制度管理
export function addEnterpriseSystem(data) {
  return request({
    url: '/safetyManagement/enterpriseSystem',
    method: 'post',
    data: data
  })
}

// 修改企业制度管理
export function updateEnterpriseSystem(data) {
  return request({
    url: '/safetyManagement/enterpriseSystem',
    method: 'put',
    data: data
  })
}

// 删除企业制度管理
export function delEnterpriseSystem(systemId) {
  return request({
    url: '/safetyManagement/enterpriseSystem/' + systemId,
    method: 'delete'
  })
}

// 导出企业制度管理
export function exportEnterpriseSystem(query) {
  return request({
    url: '/safetyManagement/enterpriseSystem/export',
    method: 'get',
    params: query
  })
}