import request from '@/utils/request'

// 查询企业基础信息管理列表
export function listEnterpriseInfo(query) {
  return request({
    url: '/safetyManagement/enterpriseInfo/list',
    method: 'get',
    params: query
  })
}

// 查询企业基础信息管理详细
export function getEnterpriseInfo(id) {
  return request({
    url: '/safetyManagement/enterpriseInfo/' + id,
    method: 'get'
  })
}

// 新增企业基础信息管理
export function addEnterpriseInfo(data) {
  return request({
    url: '/safetyManagement/enterpriseInfo',
    method: 'post',
    data: data
  })
}

// 修改企业基础信息管理
export function updateEnterpriseInfo(data) {
  return request({
    url: '/safetyManagement/enterpriseInfo',
    method: 'put',
    data: data
  })
}

// 删除企业基础信息管理
export function delEnterpriseInfo(id) {
  return request({
    url: '/safetyManagement/enterpriseInfo/' + id,
    method: 'delete'
  })
}

// 导出企业基础信息管理
export function exportEnterpriseInfo(query) {
  return request({
    url: '/safetyManagement/enterpriseInfo/export',
    method: 'get',
    params: query
  })
}