import request from '@/utils/request'

// 查询安全承诺公告列表
export function listAnnouncement(query) {
  return request({
    url: '/safetyManagement/announcement/list',
    method: 'get',
    params: query
  })
}

// 查询安全承诺公告详细
export function getCurrent(query) {
  return request({
    url: '/safetyManagement/announcement/getCurrent',
    method: 'get',
    params: query
  })
}

// 查询安全承诺公告详细
export function getAnnouncement(id) {
  return request({
    url: '/safetyManagement/announcement/' + id,
    method: 'get'
  })
}

// 新增安全承诺公告
export function addAnnouncement(data) {
  return request({
    url: '/safetyManagement/announcement',
    method: 'post',
    data: data
  })
}

// 修改安全承诺公告
export function updateAnnouncement(data) {
  return request({
    url: '/safetyManagement/announcement',
    method: 'put',
    data: data
  })
}

// 删除安全承诺公告
export function delAnnouncement(id) {
  return request({
    url: '/safetyManagement/announcement/' + id,
    method: 'delete'
  })
}

// 导出安全承诺公告
export function exportAnnouncement(query) {
  return request({
    url: '/safetyManagement/announcement/export',
    method: 'get',
    params: query
  })
}
